/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.standard.WindowsMenuCreator;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.DrawingListener;
import de.renew.draw.ui.impl.services.MenuServiceImpl;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;

public class WindowsMenuManager {
    private static DrawApplication _drawApplication;
    private static final List<DrawingListener> PENDING_LISTENERS;

    public static void setGui(DrawApplication drawApplication) {
        if (drawApplication != null) {
            _drawApplication = drawApplication;
            for (DrawingListener l : PENDING_LISTENERS) {
                _drawApplication.addDrawingListener(l);
            }
            PENDING_LISTENERS.clear();
        }
    }

    public static void addDrawingListener(DrawingListener drawingListener) {
        if (_drawApplication != null) {
            _drawApplication.addDrawingListener(drawingListener);
        } else {
            PENDING_LISTENERS.add(drawingListener);
        }
    }

    public static void addMenuItem(JMenuItem toAdd) {
        MenuServiceImpl menuService = new MenuServiceImpl();
        menuService.registerMenu("Windows ", toAdd);
    }

    public static void removeMenuItem(JMenuItem toRemove) {
        MenuServiceImpl menuService = new MenuServiceImpl();
        menuService.unregisterMenu(toRemove);
    }

    public static void requestFocusForDrawing(Drawing drawing) {
        _drawApplication.showDrawingViewContainer(drawing);
    }

    public static void addFocusListenerToDrawing(WindowsMenuCreator windowsMenuCreator) {
        _drawApplication.registerFocusListener(windowsMenuCreator);
    }

    public static Drawing askForCurrentlyFocusedDrawing() {
        return _drawApplication.drawing();
    }

    public static void addSavedListener(WindowsMenuCreator windowsMenuCreator) {
        _drawApplication.addSavedListener(windowsMenuCreator);
    }

    static {
        PENDING_LISTENERS = new ArrayList<DrawingListener>();
    }
}

