/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.application.SavedListener;
import CH.ifa.draw.standard.DrawingButtonBinding;
import CH.ifa.draw.standard.StandardDrawingViewContainer;
import CH.ifa.draw.standard.WindowsMenuManager;
import bibliothek.gui.dock.common.event.CFocusListener;
import bibliothek.gui.dock.common.intern.CDockable;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.DrawingListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.apache.log4j.Logger;

public class WindowsMenuCreator
implements DrawingListener,
ItemListener,
CFocusListener,
SavedListener {
    private static final Logger LOGGER = Logger.getLogger(WindowsMenuCreator.class);
    private final ButtonGroup _buttonGroup = new ButtonGroup();
    private final List<DrawingButtonBinding> _drawingButtonBindings = new ArrayList<DrawingButtonBinding>();

    public Collection<JMenuItem> createMenus() {
        try {
            WindowsMenuManager.addDrawingListener(this);
            return this._drawingButtonBindings.stream().map(DrawingButtonBinding::menuItem).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void drawingReleased(Drawing drawing) {
        JRadioButtonMenuItem itemToBeRemoved = this._drawingButtonBindings.stream().filter(e -> e.drawing().equals(drawing)).map(DrawingButtonBinding::menuItem).findFirst().orElse(null);
        this._buttonGroup.remove(itemToBeRemoved);
        WindowsMenuManager.removeMenuItem(itemToBeRemoved);
    }

    @Override
    public void drawingAdded(Drawing drawing) {
        JRadioButtonMenuItem radioButtonItem = new JRadioButtonMenuItem(drawing.getName());
        UUID uniqueId = UUID.randomUUID();
        radioButtonItem.putClientProperty("ch.ifa.draw.menu.id", uniqueId.toString());
        radioButtonItem.setSelected(true);
        this._buttonGroup.add(radioButtonItem);
        this._drawingButtonBindings.add(new DrawingButtonBinding(drawing, radioButtonItem));
        radioButtonItem.addItemListener(this);
        WindowsMenuManager.addFocusListenerToDrawing(this);
        WindowsMenuManager.addMenuItem(radioButtonItem);
        WindowsMenuManager.addSavedListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JRadioButtonMenuItem selectedItem = (JRadioButtonMenuItem)e.getSource();
        Drawing drawingToSelect = this._drawingButtonBindings.stream().filter(s -> s.menuItem() == selectedItem).map(DrawingButtonBinding::drawing).findFirst().orElse(null);
        WindowsMenuManager.requestFocusForDrawing(drawingToSelect);
    }

    public void focusGained(CDockable cDockable) {
        if (cDockable instanceof StandardDrawingViewContainer) {
            Drawing focusedDrawing = WindowsMenuManager.askForCurrentlyFocusedDrawing();
            for (DrawingButtonBinding binding : this._drawingButtonBindings) {
                if (!binding.drawing().equals(focusedDrawing) || binding.menuItem().isSelected()) continue;
                binding.menuItem().setSelected(true);
            }
        }
    }

    public void focusLost(CDockable cDockable) {
    }

    @Override
    public void drawingWasSaved(Drawing drawing) {
        JRadioButtonMenuItem item = this._drawingButtonBindings.stream().filter(e -> e.drawing().equals(drawing)).map(DrawingButtonBinding::menuItem).findFirst().orElse(null);
        if (item != null) {
            item.setSelected(true);
            item.setText(drawing.getName());
        }
    }
}

