/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;

@Deprecated(since="5.0", forRemoval=true)
public class MultiLineLabel
extends Component {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    protected String label;
    protected int margin_width;
    protected int margin_height;
    protected int alignment;
    protected int numLines;
    protected String[] lines;
    protected int[] line_widths;
    protected int max_width;
    protected int line_height;
    protected int line_ascent;
    protected boolean measured = false;

    public MultiLineLabel(String label, int marginWidth, int marginHeight, int alignment) {
        this.label = label;
        this.margin_width = marginWidth;
        this.margin_height = marginHeight;
        this.alignment = alignment;
        this.newLabel();
    }

    public MultiLineLabel(String label, int marginWidth, int marginHeight) {
        this(label, marginWidth, marginHeight, 0);
    }

    public MultiLineLabel(String label, int alignment) {
        this(label, 10, 10, alignment);
    }

    public MultiLineLabel(String label) {
        this(label, 10, 10, 0);
    }

    public MultiLineLabel() {
        this("");
    }

    public void setLabel(String label) {
        this.label = label;
        this.newLabel();
        this.measured = false;
        this.repaint();
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.measured = false;
        this.repaint();
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.repaint();
    }

    public void setAlignment(int a) {
        this.alignment = a;
        this.repaint();
    }

    public void setMarginWidth(int mw) {
        this.margin_width = mw;
        this.repaint();
    }

    public void setMarginHeight(int mh) {
        this.margin_height = mh;
        this.repaint();
    }

    public String getLabel() {
        return this.label;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getMarginWidth() {
        return this.margin_width;
    }

    public int getMarginHeight() {
        return this.margin_height;
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.measured) {
            this.measure();
        }
        return new Dimension(this.max_width + 2 * this.margin_width, this.numLines * this.line_height + 2 * this.margin_height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paint(Graphics g) {
        Dimension size = this.getSize();
        if (!this.measured) {
            this.measure();
        }
        int y = this.line_ascent + (size.height - this.numLines * this.line_height) / 2;
        int i = 0;
        while (i < this.numLines) {
            int x = switch (this.alignment) {
                case 1 -> (size.width - this.line_widths[i]) / 2;
                case 2 -> size.width - this.margin_width - this.line_widths[i];
                default -> this.margin_width;
            };
            g.drawString(this.lines[i], x, y);
            ++i;
            y += this.line_height;
        }
    }

    protected synchronized void newLabel() {
        StringTokenizer t = new StringTokenizer(this.label, "\n");
        this.numLines = t.countTokens();
        this.lines = new String[this.numLines];
        this.line_widths = new int[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i] = t.nextToken();
        }
    }

    protected synchronized void measure() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.line_height = fm.getHeight();
        this.line_ascent = fm.getAscent();
        this.max_width = 0;
        for (int i = 0; i < this.numLines; ++i) {
            this.line_widths[i] = fm.stringWidth(this.lines[i]);
            if (this.line_widths[i] <= this.max_width) continue;
            this.max_width = this.line_widths[i];
        }
        this.measured = true;
    }
}

