/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.framework.HJDError;
import CH.ifa.draw.standard.InitialAttributesMenu;
import CH.ifa.draw.standard.UndoableTool;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.ui.ontology.DrawingEditor;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class CreationTool
extends UndoableTool {
    private Point _anchorpoint;
    private Figure _createdfigure;
    private final Figure _prototype;

    public CreationTool(DrawingEditor editor, Figure prototype) {
        super(editor);
        this._prototype = prototype;
    }

    protected CreationTool(DrawingEditor editor) {
        super(editor);
        this._prototype = null;
    }

    protected Figure getPrototype() {
        return this._prototype;
    }

    @Override
    public void activate() {
        super.activate();
        this.view().setCursor(Cursor.getPredefinedCursor(1));
        this._anchorpoint = null;
        this._createdfigure = null;
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        this._createdfigure = this.createFigure();
        this._anchorpoint = e.isControlDown() ? new Point(x, x - this._createdfigure.displayBox().x + this._createdfigure.displayBox().y) : new Point(x, y);
        this._createdfigure.displayBox(this._anchorpoint, this._anchorpoint);
        this.view().add(this._createdfigure);
        this.changesMade();
    }

    protected Figure createFigure() {
        if (this._prototype == null) {
            throw new HJDError("No prototype defined");
        }
        return (Figure)this._prototype.clone();
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        if (e.isControlDown()) {
            this._createdfigure.displayBox(this._anchorpoint, new Point(x, x - this._createdfigure.displayBox().x + this._createdfigure.displayBox().y));
        } else {
            this._createdfigure.displayBox(this._anchorpoint, new Point(x, y));
        }
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        if (this._createdfigure.isEmpty()) {
            this.drawing().remove(this._createdfigure);
            this.noChangesMade();
        }
        this._createdfigure = null;
        this.editor().toolDone();
    }

    protected Figure createdFigure() {
        return this._createdfigure;
    }

    public Component initialAttributesMenu() {
        if (this._prototype instanceof AttributeFigure) {
            return new InitialAttributesMenu((AttributeFigure)this._prototype);
        }
        return null;
    }
}

