/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.io;

import CH.ifa.draw.io.SimpleFileFilter;
import de.renew.ioontology.ExtensionFileFilter;
import de.renew.ioontology.FileFilter;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;

public class CombinationFileFilter
extends SimpleFileFilter
implements java.io.FileFilter {
    private final HashSet<SimpleFileFilter> filterList = new HashSet();
    private SimpleFileFilter preferredFileFilter;
    private String description;
    private boolean allowDirectory = true;
    private boolean allowHidden = false;

    public CombinationFileFilter(String description) {
        this.setDescription(description);
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public boolean add(SimpleFileFilter ff) {
        boolean result = false;
        if (!this.contains(ff)) {
            if (this.filterList.isEmpty()) {
                this.preferredFileFilter = ff;
            }
            result = this.filterList.add(ff);
        }
        return result;
    }

    public boolean add(final FileFilter ff) {
        SimpleFileFilter simpleFileFilter = new SimpleFileFilter(){

            @Override
            public boolean accept(File f) {
                return ff.accept(f);
            }
        };
        simpleFileFilter.setDescription(ff.getDescription());
        return this.add(simpleFileFilter);
    }

    public boolean add(ExtensionFileFilter ff) {
        return this.add(new SimpleFileFilter(ff.getExtension(), ff.getDescription()));
    }

    public boolean addAll(Collection<? extends FileFilter> filters) {
        boolean result = false;
        for (FileFilter fileFilter : filters) {
            if (fileFilter instanceof ExtensionFileFilter) {
                ExtensionFileFilter extensionFileFilter = (ExtensionFileFilter)fileFilter;
                result = this.add(extensionFileFilter) || result;
                continue;
            }
            result = this.add(fileFilter) || result;
        }
        return result;
    }

    public boolean contains(SimpleFileFilter filter) {
        boolean result = false;
        for (SimpleFileFilter ff : this.filterList) {
            if (filter == null || !filter.equals(ff)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean contains(ExtensionFileFilter filter) {
        return this.contains(new SimpleFileFilter(filter.getExtension(), filter.getDescription()));
    }

    public void remove(SimpleFileFilter ff) {
        this.filterList.remove(ff);
    }

    public void remove(ExtensionFileFilter ff) {
        this.filterList.remove(new SimpleFileFilter(ff.getExtension(), ff.getDescription()));
    }

    public HashSet<SimpleFileFilter> getFileFilters() {
        return this.filterList;
    }

    @Override
    public String getExtension() {
        return this.getPreferedFileFilter().getExtension();
    }

    @Override
    public void allowHidden(boolean b) {
        this.allowHidden = b;
    }

    @Override
    public void allowDirectory(boolean b) {
        this.allowDirectory = b;
    }

    @Override
    public boolean isHiddenAllowed() {
        return this.allowHidden;
    }

    @Override
    public boolean isDirectoryAllowed() {
        return this.allowDirectory;
    }

    @Override
    public boolean accept(File f) {
        if (f == null) {
            return false;
        }
        if (!this.allowHidden && (f.isHidden() || f.getName().startsWith("."))) {
            return false;
        }
        if (f.isDirectory()) {
            return this.allowDirectory;
        }
        for (SimpleFileFilter filter : this.filterList) {
            if (!filter.accept(f)) continue;
            return true;
        }
        return false;
    }

    public SimpleFileFilter getPreferedFileFilter() {
        return this.preferredFileFilter;
    }

    public void setPreferedFileFilter(SimpleFileFilter filter) {
        this.preferredFileFilter = filter;
    }

    public void setPreferedFileFilter(final FileFilter filter) {
        this.preferredFileFilter = new SimpleFileFilter(){

            @Override
            public boolean accept(File f) {
                return filter.accept(f);
            }
        };
        this.preferredFileFilter.setDescription(filter.getDescription());
    }

    public boolean isEmpty() {
        return this.filterList.isEmpty();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof CombinationFileFilter) {
            CombinationFileFilter other = (CombinationFileFilter)o;
            return this.getDescription().equals(other.getDescription()) && this.getFileFilters().equals(other.getFileFilters());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return CombinationFileFilter.class.hashCode() ^ this.getDescription().hashCode() ^ this.getFileFilters().hashCode();
    }
}

