/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.gui;

import CH.ifa.draw.gui.ToolPanelLayout;
import bibliothek.gui.DockUI;
import de.renew.plugin.PluginManager;
import de.renew.windowmanagement.DraggableComponentDropTarget;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.apache.log4j.Logger;

@Deprecated
public class ToolButtonContainer
extends JPanel
implements DraggableComponentDropTarget {
    private static final String IMAGES = "CH/ifa/draw/images/";
    private final Set<AbstractButton> _buttons;
    private static final Logger LOGGER = Logger.getLogger(ToolButtonContainer.class);
    private ToolButtonPalette _palette;
    private JPanel _titleBar;

    public ToolButtonContainer(Set<AbstractButton> buttons) {
        this._buttons = buttons;
        this.createPalette();
        this.createTitleBar();
        this.setLayout(new BorderLayout());
        this.add((Component)this._titleBar, "North");
        this.add((Component)this._palette, "Center");
    }

    private JToggleButton createHideToolsButton() {
        JToggleButton button = new JToggleButton();
        button.setIcon(new ImageIcon(this.loadImage("CH/ifa/draw/images/toolbuttons_hid.png")));
        button.setSelectedIcon(new ImageIcon(this.loadImage("CH/ifa/draw/images/toolbuttons_open.png")));
        button.setToolTipText("Show/Hide tools");
        button.setSelected(true);
        button.addActionListener(e -> {
            boolean newState = !this._palette.isVisible();
            this._palette.setVisible(newState);
        });
        return button;
    }

    private JButton createCloseButton() {
        JButton button = new JButton();
        button.setIcon(new ImageIcon(this.loadImage("CH/ifa/draw/images/toolbuttons_close.png")));
        ToolButtonContainer container = this;
        button.addActionListener(e -> {
            Container parent = container.getParent();
            if (parent != null) {
                parent.remove(container);
                parent.revalidate();
            }
        });
        button.setToolTipText("Close Tools");
        return button;
    }

    private void createPalette() {
        this._palette = new ToolButtonPalette();
        int minWidth = 35;
        for (AbstractButton button1 : this._buttons) {
            this._palette.add(button1);
            int tempWidth = button1.getIcon().getIconWidth();
            if (minWidth >= tempWidth) continue;
            minWidth = tempWidth;
        }
        int maxWidth = 50 < minWidth ? minWidth * 2 : 50;
        this._palette.setLayout(new ToolPanelLayout(minWidth, maxWidth));
        final ToolButtonContainer container = this;
        this._palette.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentRemoved(ContainerEvent e) {
                Container parent;
                if (ToolButtonContainer.this._palette.getComponentCount() == 0 && (parent = container.getParent()) != null) {
                    parent.remove(container);
                    parent.revalidate();
                }
            }
        });
    }

    private void createTitleBar() {
        this.createHideToolsButton();
        this.createCloseButton();
        this._titleBar = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                Color background = DockUI.getColor((String)"dock.title.selection.background");
                Color light = DockUI.getColor((String)"dock.title.background");
                Graphics2D g2 = (Graphics2D)g;
                GradientPaint backgroundPaint = new GradientPaint(0.0f, 0.0f, background, this.getWidth(), this.getHeight(), light);
                g2.setPaint(backgroundPaint);
                g2.fill(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            }
        };
        this._titleBar.setLayout(new BorderLayout());
        this._titleBar.add((Component)this.createHideToolsButton(), "West");
        this._titleBar.add((Component)this.createCloseButton(), "East");
        this._titleBar.setBorder(BorderFactory.createLoweredSoftBevelBorder());
    }

    protected Component[] getButtons() {
        return this._palette.getComponents();
    }

    public void dropComponent(Component draggedComponent, Point locationOnScreen) {
        if (this._palette.isShowing()) {
            this._palette.dropComponent(draggedComponent, locationOnScreen);
        }
    }

    private BufferedImage loadImage(String path) {
        URL url = PluginManager.getInstance().getBottomClassLoader().getResource(path);
        if (url == null) {
            File file = new File(path);
            try {
                url = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOGGER.error((Object)("URL is not valid" + String.valueOf(e)));
            }
        }
        if (url != null) {
            try {
                return ImageIO.read(url);
            }
            catch (IOException e) {
                LOGGER.error((Object)("Reading from URL failed" + String.valueOf(e)));
            }
        }
        return null;
    }

    private static class ToolButtonPalette
    extends JPanel
    implements DraggableComponentDropTarget {
        private ToolButtonPalette() {
        }

        public void dropComponent(Component draggedComponent, Point locationOnScreen) {
            if (draggedComponent instanceof AbstractButton) {
                Point thisLocation = this.getLocationOnScreen();
                Point adjustedLocation = new Point(locationOnScreen.x - thisLocation.x, locationOnScreen.y - thisLocation.y);
                Component target = this.getComponentAt(adjustedLocation);
                int index = 0;
                int count = this.getComponentCount();
                for (int i = 0; i < count; ++i) {
                    if (this.getComponent(i) != target) continue;
                    index = i;
                    break;
                }
                this.add(draggedComponent, index);
            }
        }
    }
}

