/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.PolyLineable;
import CH.ifa.draw.standard.ChopBoxConnector;
import CH.ifa.draw.util.Geom;
import de.renew.draw.storables.ontology.Figure;
import java.awt.Point;
import java.awt.Rectangle;

public class PolyLineConnector
extends ChopBoxConnector {
    private static final long serialVersionUID = 6018435940519102865L;

    public PolyLineConnector() {
    }

    public PolyLineConnector(Figure owner) {
        super(owner);
    }

    protected Point chop(Figure target, Point from) {
        int i;
        PolyLineable p = (PolyLineable)this.owner();
        Point ctr = p.center();
        int cx = -1;
        int cy = -1;
        long len = Long.MAX_VALUE;
        for (i = 0; i < p.pointCount() - 1; ++i) {
            long cl;
            Point p1 = p.pointAt(i);
            Point p2 = p.pointAt(i + 1);
            Point chop = Geom.intersect(p1.x, p1.y, p2.x, p2.y, from.x, from.y, ctr.x, ctr.y);
            if (chop == null || (cl = Geom.length2(chop.x, chop.y, from.x, from.y)) >= len) continue;
            len = cl;
            cx = chop.x;
            cy = chop.y;
        }
        if (len == Long.MAX_VALUE) {
            for (i = 0; i < p.pointCount(); ++i) {
                Point pp = p.pointAt(i);
                long l = Geom.length2(pp.x, pp.y, from.x, from.y);
                if (l >= len) continue;
                len = l;
                cx = pp.x;
                cy = pp.y;
            }
        }
        return new Point(cx, cy);
    }

    @Override
    protected Point chop(Figure target, Rectangle source) {
        return this.chop(target, Geom.center(source));
    }
}

