/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.standard.ChangeConnectionEndHandle;
import CH.ifa.draw.standard.ChangeConnectionStartHandle;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.MergedFigureEnumerator;
import de.renew.draw.storables.api.StorableApi;
import de.renew.draw.storables.ontology.ConnectionFigure;
import de.renew.draw.storables.ontology.Connector;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureChangeEvent;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.draw.ui.ontology.FigureHandle;
import java.awt.Point;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class LineConnection
extends PolyLineFigure
implements ConnectionFigure {
    private static final long serialVersionUID = 6883731614578414801L;
    protected Connector fStart = null;
    protected Connector fEnd = null;
    private final int _lineConnectionSerializedDataVersion = 1;

    public LineConnection() {
        super(4);
        this.setStartDecoration();
        this.setEndDecoration();
    }

    public LineConnection(LineDecoration start, LineDecoration end, String lineStyle) {
        super(2);
        this.setStartDecoration(start);
        this.setEndDecoration(end);
        this.setLineStyle(lineStyle);
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    protected void basicMoveBy(int dx, int dy) {
        ((Point)this.fPoints.firstElement()).translate(-dx, -dy);
        ((Point)this.fPoints.lastElement()).translate(-dx, -dy);
        super.basicMoveBy(dx, dy);
        this.updateConnection();
    }

    @Override
    public void connectStart(Connector start) {
        this.fStart = start;
        this.startFigure().addFigureChangeListener(this);
        if (this.fStart != null && this.fEnd != null) {
            this.handleAdjust(this.startFigure(), this.endFigure());
        } else {
            this.handleConnect(this.startFigure(), this.endFigure());
        }
        if (GUI_LOGGER.isTraceEnabled()) {
            GUI_LOGGER.trace((Object)("LineConnection: set start of " + String.valueOf(this) + " to " + String.valueOf(this.startFigure())));
        }
    }

    @Override
    public void connectEnd(Connector end) {
        Connector oldEnd = this.fEnd;
        this.fEnd = end;
        this.endFigure().addFigureChangeListener(this);
        if (oldEnd == null) {
            this.handleConnect(this.startFigure(), this.endFigure());
        } else {
            this.handleAdjust(this.startFigure(), this.endFigure());
        }
        if (GUI_LOGGER.isTraceEnabled()) {
            GUI_LOGGER.trace((Object)("LineConnection: set end of " + String.valueOf(this) + " to " + String.valueOf(this.endFigure())));
        }
    }

    @Override
    public void disconnectStart() {
        this.handleDisconnect(this.startFigure(), this.endFigure());
        this.startFigure().removeFigureChangeListener(this);
        this.fStart = null;
    }

    @Override
    public void disconnectEnd() {
        this.handleDisconnect(this.startFigure(), this.endFigure());
        this.endFigure().removeFigureChangeListener(this);
    }

    @Override
    public boolean connectsSame(ConnectionFigure other) {
        return other.start() == this.start() && other.end() == this.end();
    }

    protected void handleDisconnect(Figure start, Figure end) {
    }

    protected void handleAdjust(Figure start, Figure end) {
    }

    protected void handleConnect(Figure start, Figure end) {
    }

    public Figure startFigure() {
        if (this.start() != null) {
            return this.start().owner();
        }
        return null;
    }

    public Figure endFigure() {
        if (this.end() != null) {
            return this.end().owner();
        }
        return null;
    }

    @Override
    public Connector start() {
        return this.fStart;
    }

    @Override
    public Connector end() {
        return this.fEnd;
    }

    @Override
    public boolean canConnect(Figure start, Figure end) {
        return true;
    }

    @Override
    public void startPoint(int x, int y) {
        this.willChange();
        if (this.fPoints.isEmpty()) {
            super.addPoint(x, y);
        } else {
            super.setPointAt(new Point(x, y), 0);
        }
    }

    @Override
    public void startPoint(Point p) {
        this.startPoint(p.x, p.y);
    }

    @Override
    public void endPoint(int x, int y) {
        this.willChange();
        if (this.fPoints.size() < 2) {
            super.addPoint(x, y);
        } else {
            super.setPointAt(new Point(x, y), this.fPoints.size() - 1);
        }
    }

    @Override
    public void endPoint(Point p) {
        this.endPoint(p.x, p.y);
    }

    @Override
    public Point startPoint() {
        Point p = (Point)this.fPoints.firstElement();
        return new Point(p.x, p.y);
    }

    @Override
    public Point endPoint() {
        Point p = (Point)this.fPoints.lastElement();
        return new Point(p.x, p.y);
    }

    @Override
    public Vector<FigureHandle> handles() {
        int n = this.fPoints.size();
        Vector<FigureHandle> handles = new Vector<FigureHandle>(2 * n);
        handles.addElement(new ChangeConnectionStartHandle(this));
        this.addIntermediateHandles(handles);
        handles.addElement(new ChangeConnectionEndHandle(this));
        return handles;
    }

    @Override
    public void setPointAt(Point p, int i) {
        super.setPointAt(p, i);
        this.layoutConnection();
    }

    @Override
    public void insertPointAt(Point p, int i) {
        super.insertPointAt(p, i);
        this.layoutConnection();
    }

    @Override
    public void removePointAt(int i) {
        super.removePointAt(i);
        this.layoutConnection();
    }

    @Override
    public void updateConnection() {
        if (this.fStart != null) {
            Point start = this.fStart.findStart(this);
            this.startPoint(start.x, start.y);
        }
        if (this.fEnd != null) {
            Point end = this.fEnd.findEnd(this);
            this.endPoint(end.x, end.y);
        }
    }

    public void layoutConnection() {
        this.updateConnection();
    }

    @Override
    public void figureChanged(FigureChangeEvent e) {
        this.updateConnection();
    }

    @Override
    public void figureHandlesChanged(FigureChangeEvent e) {
    }

    @Override
    public void figureRemoved(FigureChangeEvent e) {
        if (this.listener() != null) {
            this.listener().figureRequestRemove(StorableApi.createFigureChangeEvent(this));
        }
    }

    @Override
    public void figureRequestRemove(FigureChangeEvent e) {
    }

    @Override
    public void figureInvalidated(FigureChangeEvent e) {
    }

    @Override
    public void figureRequestUpdate(FigureChangeEvent e) {
    }

    @Override
    public void release() {
        super.release();
        if (this.fStart != null && this.fEnd != null) {
            this.handleDisconnect(this.startFigure(), this.endFigure());
        }
        if (this.fStart != null) {
            this.startFigure().removeFigureChangeListener(this);
        }
        if (this.fEnd != null) {
            this.endFigure().removeFigureChangeListener(this);
        }
    }

    @Override
    public FigureEnumeration getFiguresWithDependencies() {
        FigureEnumeration superDep = super.getFiguresWithDependencies();
        Vector<Figure> myDep = new Vector<Figure>(2);
        myDep.addElement(this.start().owner());
        myDep.addElement(this.end().owner());
        return new MergedFigureEnumerator(superDep, new FigureEnumerator(myDep));
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fStart);
        dw.writeStorable(this.fEnd);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        Connector end;
        super.read(dr);
        Connector start = (Connector)dr.readStorable();
        if (start != null) {
            this.connectStart(start);
        }
        if ((end = (Connector)dr.readStorable()) != null) {
            this.connectEnd(end);
        }
        if (start != null && end != null) {
            this.updateConnection();
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.fStart != null) {
            this.connectStart(this.fStart);
        }
        if (this.fEnd != null) {
            this.connectEnd(this.fEnd);
        }
    }
}

