/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.ChopEllipseConnector;
import CH.ifa.draw.standard.BoxHandleKit;
import CH.ifa.draw.util.Geom;
import de.renew.draw.storables.ontology.Connector;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.draw.ui.ontology.FigureHandle;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.io.IOException;
import java.util.Vector;

public class EllipseFigure
extends AttributeFigure {
    private static final long serialVersionUID = -6856203289355118951L;
    private Rectangle _displayBox;
    private final int _ellipseFigureSerializedDataVersion = 1;

    public EllipseFigure() {
        this(new Point(0, 0), new Point(0, 0));
    }

    public EllipseFigure(Point origin, Point corner) {
        this.basicDisplayBox(origin, corner);
    }

    @Override
    public Vector<FigureHandle> handles() {
        Vector<FigureHandle> handles = new Vector<FigureHandle>();
        BoxHandleKit.addHandles(this, handles);
        return handles;
    }

    @Override
    public void basicDisplayBox(Point origin, Point corner) {
        this._displayBox = new Rectangle(origin);
        this._displayBox.add(corner);
    }

    @Override
    public Rectangle displayBox() {
        return new Rectangle(this._displayBox.x, this._displayBox.y, this._displayBox.width, this._displayBox.height);
    }

    @Override
    public boolean containsPoint(int x, int y) {
        if (super.containsPoint(x, y)) {
            return Geom.ellipseContainsPoint(this.displayBox(), x, y);
        }
        return false;
    }

    @Override
    protected void basicMoveBy(int x, int y) {
        this._displayBox.translate(x, y);
    }

    @Override
    public void drawBackground(Graphics g) {
        Rectangle r = this.displayBox();
        Graphics2D g2 = (Graphics2D)g;
        Ellipse2D.Double s = new Ellipse2D.Double(r.x, r.y, r.width, r.height);
        g2.fill(s);
    }

    @Override
    public void drawFrame(Graphics g) {
        Rectangle r = this.displayBox();
        Graphics2D g2 = (Graphics2D)g;
        Ellipse2D.Double s = new Ellipse2D.Double(r.x, r.y, r.width, r.height);
        g2.draw(s);
    }

    @Override
    public Insets connectionInsets() {
        Rectangle r = this._displayBox;
        int cx = r.width / 2;
        int cy = r.height / 2;
        return new Insets(cy, cx, cy, cx);
    }

    @Override
    public Connector connectorAt(int x, int y) {
        return new ChopEllipseConnector(this);
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this._displayBox.x);
        dw.writeInt(this._displayBox.y);
        dw.writeInt(this._displayBox.width);
        dw.writeInt(this._displayBox.height);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this._displayBox = new Rectangle(dr.readInt(), dr.readInt(), dr.readInt(), dr.readInt());
    }
}

