/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.application;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.application.WindowsMenu;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.CommandMenuItem;
import de.renew.draw.ui.ontology.AbstractCommand;
import de.renew.draw.ui.ontology.MenuSeparatorFactory;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

public class MenuManager {
    @Deprecated
    public static Logger logger = Logger.getLogger(MenuManager.class);
    @Deprecated
    public static final String ID_PROPERTY = "ch.ifa.draw.menu.id";
    private static MenuManager instance;
    @Deprecated
    public static final int AT_BEGIN_SECTION = 0;
    @Deprecated
    public static final int AT_END_SECTION = 1;
    @Deprecated
    public static final int SECTION_MIDDLE = 2;
    private HashMap<String, SeparatorFactory> separatorFactories;
    private final HashMap<String, JMenu> toplevelMenus;
    private final HashMap<String, JMenuItem> registeredMenus;
    private final Map<Integer, List<String>> toplevelOrder = new HashMap<Integer, List<String>>();
    private DrawApplication application = null;
    private final boolean windowsMenuPresent = false;
    private boolean helpMenuPresent = false;

    private MenuManager() {
        this.toplevelMenus = new HashMap();
        this.registeredMenus = new HashMap();
        WindowsMenu winMenu = new WindowsMenu("Windows");
        this.toplevelMenus.put("Windows", winMenu);
    }

    @Deprecated
    public static MenuManager getInstance() {
        if (instance == null) {
            instance = new MenuManager();
        }
        return instance;
    }

    @Deprecated
    public synchronized void registerMenu(String parentMenu, JMenuItem toRegister) {
        JMenu parent = this.getOrCreateParentMenu(parentMenu);
        String id = (String)toRegister.getClientProperty(ID_PROPERTY);
        if (id == null) {
            logger.error((Object)(String.valueOf(this.getClass()) + ": could not register menu " + String.valueOf(toRegister) + ": please set ch.ifa.draw.menu.id with menu.setClientProperty()."));
            return;
        }
        if (toRegister instanceof SeparatorItem) {
            this.registeredMenus.put(id, toRegister);
            parent.addSeparator();
        } else {
            this.registeredMenus.put(id, toRegister);
            parent.add(toRegister);
        }
        logger.debug((Object)(String.valueOf(this.getClass()) + ": the menu " + toRegister.getText() + " has been registered under " + parentMenu + ", id " + String.valueOf(toRegister.getClientProperty(ID_PROPERTY))));
    }

    @Deprecated
    public synchronized void registerMenu(String parentMenu, JPopupMenu.Separator separator) {
        JMenu parent = this.getOrCreateParentMenu(parentMenu);
        String id = (String)separator.getClientProperty(ID_PROPERTY);
        if (id == null) {
            logger.error((Object)(String.valueOf(this.getClass()) + ": could not register separator " + String.valueOf(separator) + ": please set ch.ifa.draw.menu.id with menu.setClientProperty()."));
            return;
        }
        parent.addSeparator();
    }

    @Deprecated
    public synchronized void registerMenu(String parentMenu, JMenuItem toRegister, int separator) {
        SeparatorFactory factory = this.getFactory(parentMenu);
        if (separator == 0) {
            this.registerMenu(parentMenu, factory.createJPopupMenuSeparator(toRegister.getClientProperty(ID_PROPERTY)));
        }
        this.registerMenu(parentMenu, toRegister);
        if (separator == 1) {
            this.registerMenu(parentMenu, factory.createJPopupMenuSeparator(toRegister.getClientProperty(ID_PROPERTY)));
        }
    }

    @Deprecated
    public void registerMenu(String parentMenu, JMenuItem toRegister, String id) {
        toRegister.putClientProperty(ID_PROPERTY, id);
        this.registerMenu(parentMenu, toRegister);
    }

    @Deprecated
    public void registerHeading(String parentMenu, String headingText, String id) {
        this.registerHeading(parentMenu, headingText, id, 1);
    }

    @Deprecated
    public void registerHeading(String parentMenu, String headingText, String id, int section) {
        JMenuItem item = new JMenuItem(headingText);
        item.setEnabled(false);
        item.setFont(item.getFont().deriveFont(1));
        item.putClientProperty(ID_PROPERTY, id);
        if (section == 1) {
            this.registerMenu(parentMenu, item);
        } else {
            this.registerMenu(parentMenu, item, section, 0);
        }
    }

    @Deprecated
    public synchronized void registerMenu(String parentMenu, JMenuItem toRegister, int requestedSection, int where) {
        if (requestedSection == 0 || where > 2 || where < 0) {
            logger.error((Object)(this.getClass().getSimpleName() + ": could not register menu item " + toRegister.getText() + "\nparameter 'where' must be  0 < where < 3 and sections start with 1"));
            return;
        }
        JMenu parent = this.getOrCreateParentMenu(parentMenu);
        String id = (String)toRegister.getClientProperty(ID_PROPERTY);
        if (id == null || parent == null) {
            logger.error((Object)(this.getClass().getSimpleName() + ": could not register menu item " + toRegister.getText() + (String)(id == null ? ": please set ch.ifa.draw.menu.id with menu.setClientProperty()." : " toplevel menu " + parentMenu + " does not exist")));
            return;
        }
        this.registeredMenus.put(id, toRegister);
        Component[] menuComps = parent.getMenuComponents();
        if (menuComps.length > 0) {
            int pos = 0;
            int sec = 1;
            int itemsInSec = 0;
            while (pos < menuComps.length && sec <= requestedSection) {
                boolean nextIsSep;
                boolean bl = nextIsSep = pos + 1 >= menuComps.length || menuComps[pos + 1] instanceof JPopupMenu.Separator;
                if (sec == requestedSection) {
                    if (where == 0) {
                        parent.add((Component)toRegister, pos);
                        break;
                    }
                    if (nextIsSep) {
                        if (where == 1) {
                            parent.add((Component)toRegister, pos + 1);
                        } else {
                            parent.add((Component)toRegister, itemsInSec / 2 + (pos + 1 - itemsInSec));
                        }
                        break;
                    }
                }
                if (menuComps[pos] instanceof JPopupMenu.Separator) {
                    ++sec;
                    itemsInSec = 0;
                }
                if (pos + 1 == menuComps.length) {
                    parent.add(toRegister);
                }
                ++pos;
                ++itemsInSec;
            }
        } else {
            parent.add(toRegister);
        }
        logger.debug((Object)(String.valueOf(this.getClass()) + ": the menu " + toRegister.getText() + " has been registered under " + parentMenu + ", id " + String.valueOf(toRegister.getClientProperty(ID_PROPERTY)) + "\n" + this.registeredMenus.get(id).getText()));
    }

    @Deprecated
    public void unregisterMenu(JMenuItem item) {
        if (item instanceof SeparatorItem) {
            logger.debug((Object)(String.valueOf(this.getClass()) + ": no need to unregister separator."));
            return;
        }
        String id = (String)item.getClientProperty(ID_PROPERTY);
        if (id == null) {
            logger.debug((Object)(String.valueOf(this.getClass()) + " unregistering item " + item.getText() + ": no client property set!"));
            return;
        }
        this.unregisterMenu(id);
    }

    @Deprecated
    public void unregisterMenu(JMenuItem item, int separatorType) {
        String id = (String)item.getClientProperty(ID_PROPERTY);
        if (id == null) {
            logger.debug((Object)(String.valueOf(this.getClass()) + " unregistering item " + item.getText() + ": no client property set!"));
            return;
        }
        this.unregisterMenu(id, separatorType);
    }

    @Deprecated
    public synchronized void unregisterMenu(String id) {
        AbstractButton toplevel = null;
        AbstractButton item = null;
        block0: for (JMenu nextMenu : this.toplevelMenus.values()) {
            Component[] menuComponents;
            for (Component component : menuComponents = nextMenu.getMenuComponents()) {
                JMenuItem currentItem;
                String currentId;
                if (!(component instanceof JMenuItem) || !id.equals(currentId = (String)(currentItem = (JMenuItem)component).getClientProperty(ID_PROPERTY))) continue;
                toplevel = nextMenu;
                item = currentItem;
                continue block0;
            }
        }
        if (item == null) {
            logger.debug((Object)(String.valueOf(this.getClass()) + ".unregisterMenu(): menu " + id + " not found!"));
            return;
        }
        logger.debug((Object)(String.valueOf(this.getClass()) + ": unregistering menu " + item.getText() + " from " + toplevel.getText()));
        ((JMenu)toplevel).remove((JMenuItem)item);
        this.removeLeadingSeparators((JMenu)toplevel);
        this.removeTrailingSeparators((JMenu)toplevel);
        this.reduceAdjacentSeparatorsToOne((JMenu)toplevel);
        this.removeMenuIfEmpty(toplevel.getText(), (JMenu)toplevel);
        this.registeredMenus.remove(id);
    }

    @Deprecated
    public synchronized void unregisterMenu(String id, int separatorType) {
        AbstractButton toplevel = null;
        Iterator<JMenu> tlMenus = this.toplevelMenus.values().iterator();
        AbstractButton item = null;
        JPopupMenu.Separator separator = null;
        block0: while (toplevel == null && tlMenus.hasNext()) {
            JMenu c = tlMenus.next();
            Component[] comp = c.getMenuComponents();
            for (int i = 0; i < comp.length; ++i) {
                Component tmp;
                JMenuItem currentItem;
                String currentId;
                if (!(comp[i] instanceof JMenuItem) || !id.equals(currentId = (String)(currentItem = (JMenuItem)comp[i]).getClientProperty(ID_PROPERTY))) continue;
                toplevel = c;
                item = currentItem;
                if (i - 1 >= 0 && separatorType == 0 && (tmp = comp[i - 1]) instanceof JPopupMenu.Separator) {
                    separator = (JPopupMenu.Separator)tmp;
                }
                if (i + 1 >= comp.length || separatorType != 1 || !((tmp = comp[i + 1]) instanceof JPopupMenu.Separator)) continue block0;
                separator = (JPopupMenu.Separator)tmp;
                continue block0;
            }
        }
        if (item == null) {
            logger.debug((Object)(String.valueOf(this.getClass()) + ".unregisterMenu(): menu " + id + " not found! Check registeredMenus instead..."));
            return;
        }
        logger.debug((Object)(String.valueOf(this.getClass()) + ": unregistering menu " + item.getText() + " from " + toplevel.getText()));
        ((JMenu)toplevel).remove((JMenuItem)item);
        if (separator != null) {
            ((JMenu)toplevel).remove(separator);
        }
        this.removeLeadingSeparators((JMenu)toplevel);
        this.removeTrailingSeparators((JMenu)toplevel);
        this.removeMenuIfEmpty(toplevel.getText(), (JMenu)toplevel);
        this.registeredMenus.remove(id);
    }

    private void removeLeadingSeparators(JMenu menu) {
        Objects.requireNonNull(menu);
        while (menu.getItemCount() > 0 && menu.getItem(0) == null) {
            logger.debug((Object)(String.valueOf(this.getClass()) + ": removing leading separator."));
            menu.remove(0);
        }
    }

    private void removeTrailingSeparators(JMenu menu) {
        Objects.requireNonNull(menu);
        while (menu.getItemCount() > 0 && menu.getItem(menu.getItemCount() - 1) == null) {
            logger.debug((Object)(String.valueOf(this.getClass()) + ": removing top separator."));
            menu.remove(menu.getItemCount() - 1);
        }
    }

    private void reduceAdjacentSeparatorsToOne(JMenu menu) {
        Component[] components;
        boolean foundSeparator = false;
        for (Component component : components = menu.getMenuComponents()) {
            if (component instanceof JPopupMenu.Separator) {
                if (foundSeparator) {
                    logger.debug((Object)(String.valueOf(this.getClass()) + ": reducing adjacent separators to one."));
                    menu.remove(component);
                    continue;
                }
                foundSeparator = true;
                continue;
            }
            foundSeparator = false;
        }
    }

    private void removeMenuIfEmpty(String parentMenu, JMenu menuObject) {
        if ("Windows".equals(parentMenu)) {
            return;
        }
        if (menuObject.getMenuComponentCount() == 0) {
            logger.debug((Object)(String.valueOf(this.getClass()) + ": the last MenuItem of menu " + parentMenu + " has been removed, removing menu"));
            if (this.application != null) {
                this.application.removeMenu(menuObject);
            }
            this.toplevelMenus.remove(parentMenu);
            for (Map.Entry<Integer, List<String>> entry : this.toplevelOrder.entrySet()) {
                if (entry.getValue().remove(parentMenu)) break;
            }
            if ("Help".equals(parentMenu)) {
                this.helpMenuPresent = false;
            }
        }
    }

    @Deprecated
    void setGui(DrawApplication app) {
        this.application = app;
        if (this.application == null) {
            logger.error((Object)"The DrawApplication is null, cannot set GUI.");
            return;
        }
        logger.debug((Object)(String.valueOf(this.getClass()) + ": adding menus to application object " + String.valueOf(app)));
        for (Map.Entry<Integer, List<String>> entry : this.toplevelOrder.entrySet()) {
            for (String menuName : entry.getValue()) {
                JMenu toplevelMenu = this.toplevelMenus.get(menuName);
                if (toplevelMenu != null) {
                    this.application.addMenu(toplevelMenu, entry.getKey());
                    continue;
                }
                logger.warn((Object)(String.valueOf(this.getClass()) + ": toplevel menu " + menuName + " not found in toplevelMenus map."));
            }
        }
    }

    @Deprecated
    public static JMenuItem createSeparator(String id) {
        return new SeparatorItem(id);
    }

    @Deprecated
    JMenu getToplevelMenu(String name) {
        return this.toplevelMenus.get(name);
    }

    @Deprecated
    public WindowsMenu getWindowsMenu() {
        return (WindowsMenu)this.getToplevelMenu("Windows");
    }

    @Deprecated
    public static CommandMenuItem createMenuItem(AbstractCommand command, int shortcut) {
        return new CommandMenuItem(command, shortcut);
    }

    private SeparatorFactory getFactory(String parentMenu) {
        SeparatorFactory factory = null;
        if (this.separatorFactories == null) {
            this.separatorFactories = new HashMap();
        }
        if (this.separatorFactories.containsKey(parentMenu)) {
            factory = this.separatorFactories.get(parentMenu);
        }
        if (!this.separatorFactories.containsKey(parentMenu)) {
            factory = new SeparatorFactory(parentMenu);
            this.separatorFactories.put(parentMenu, factory);
        }
        return factory;
    }

    private JMenu getOrCreateParentMenu(String parentMenu) {
        return this.createTopLevelMenu(parentMenu, 4);
    }

    @Deprecated
    public JMenu createTopLevelMenu(String parentMenu, int section) {
        JMenu parent = this.toplevelMenus.get(parentMenu);
        if (parent == null) {
            logger.debug((Object)(String.valueOf(this.getClass()) + ": creating new top level menu " + parentMenu));
            parent = new CommandMenu(parentMenu);
            this.toplevelMenus.put(parentMenu, parent);
            if (this.toplevelOrder.containsKey(section)) {
                this.toplevelOrder.get(section).add(parentMenu);
            } else {
                this.toplevelOrder.put(section, new ArrayList<String>(List.of(parentMenu)));
            }
            if (this.application != null) {
                this.application.addMenu(parent, section);
            }
        }
        return parent;
    }

    private static class SeparatorItem
    extends JMenuItem {
        public SeparatorItem(String label) {
            super(label);
        }
    }

    @Deprecated
    public static class SeparatorFactory
    implements MenuSeparatorFactory {
        public static final int _SEPARATOR_ABOVE = 0;
        public static final int _SEPARATOR_BELOW = 1;
        private int count;
        private final String id;

        @Deprecated
        public SeparatorFactory(String id) {
            this.id = id;
        }

        @Override
        public JMenuItem createSeparator() {
            SeparatorItem item = new SeparatorItem(this.id + ".sep" + this.count);
            item.putClientProperty(MenuManager.ID_PROPERTY, this.id + ".sep" + this.count++);
            return item;
        }

        @Override
        public JPopupMenu.Separator createJPopupMenuSeparator(Object menuID) {
            JPopupMenu.Separator item = new JPopupMenu.Separator();
            item.putClientProperty(MenuManager.ID_PROPERTY, this.id + "." + String.valueOf(menuID) + ".separator");
            return item;
        }

        public String getId() {
            return this.id;
        }
    }
}

