/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw;

import CH.ifa.draw.IOHelper;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.application.FileMenuCreator;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.application.NoGuiAvailableException;
import CH.ifa.draw.application.OpenDrawingCommand;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.ExportHolder;
import CH.ifa.draw.io.ExportHolderImpl;
import CH.ifa.draw.io.ImportHolder;
import CH.ifa.draw.io.ImportHolderImpl;
import CH.ifa.draw.io.StorableInputDrawingLoader;
import CH.ifa.draw.standard.AlignmentMenuCreator;
import CH.ifa.draw.standard.AttributesMenuCreator;
import CH.ifa.draw.standard.EditMenuCreator;
import CH.ifa.draw.standard.StandardDrawing;
import CH.ifa.draw.standard.WindowsMenuCreator;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.GUIProperties;
import de.renew.draw.storables.api.StorableApi;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.ui.api.EditorApi;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.annotations.Provides;
import de.renew.util.StringUtil;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class DrawPlugin
extends PluginAdapter {
    public static Logger logger = Logger.getLogger(DrawPlugin.class);
    private static DrawApplication _gui;
    private ImportHolderImpl importHolder;
    private ExportHolderImpl exportHolder;
    public static final String RECENTLY_SAVED = "recently-saved.prop";
    private static final String NUM_RECENT_FILES_KEY = "ch.ifa.draw.num-of-recent-files";
    private ArrayList<String> recentFiles = null;
    private CommandMenu recentlySavedMenu = null;
    private long recentFilesModificationDate = 0L;
    public static final String WINDOW_FOCUS_WORKAROUND_KEY = "ch.ifa.draw.window-focus-workaround";
    private static final String SHOW_RECENTLY_SAVED_HOTKEYS_KEY = "ch.ifa.draw.show-recentlysaved-hotkeys";
    public static final String CH_IFA_DRAW_GRID_SIZE = "ch.ifa.draw.grid.size";
    public static final String CH_IFA_DRAW_GRID_DEFAULT = "ch.ifa.draw.grid.default";
    @Deprecated
    public static String PLUGINS_MENU;
    @Deprecated
    public static String PLATFORMS_MENU;
    @Deprecated
    public static final String FILE_MENU = "File";
    @Deprecated
    public static final String EDIT_MENU = "Edit";
    @Deprecated
    public static final String ATTRIBUTES_MENU = "Attributes";
    @Deprecated
    public static final String LAYOUT_MENU = "Layout";
    @Deprecated
    public static final String WINDOWS_MENU = "Windows";
    @Deprecated
    public static final String TOOLS_MENU = "Tools";
    @Deprecated
    public static final String PAOSE_MENU = "Paose";
    @Deprecated
    public static final String WINDOWS_CATEGORY_TOOLS = "Tools";
    @Deprecated
    public static final String HELP_MENU = "Help";
    public static final String MENU_PREFIX = "CH.ifa.draw";
    public static final int[] keys;

    public static void setGui(DrawApplication gui) {
        logger.debug((Object)("IfaPlugin setting gui to " + String.valueOf(gui)));
        _gui = gui;
    }

    @Provides
    public static DrawApplication getGui() {
        return _gui;
    }

    public static DrawApplication getDrawPluginGui() throws IllegalStateException {
        if (_gui == null) {
            throw new IllegalStateException("GUI of type DrawApplication was accessed without being loaded");
        }
        return _gui;
    }

    public DrawPlugin(URL location) throws PluginException {
        super(location);
        DrawPlugin.checkSwing();
    }

    public DrawPlugin(PluginProperties props) throws PluginException {
        super(props);
        try {
            String tmpPlatforms;
            String tmpPlugins = PluginProperties.getUserProperties().getProperty("CH.ifa.draw.menutext.plugin");
            if (tmpPlugins != null) {
                PLUGINS_MENU = tmpPlugins;
            }
            if ((tmpPlatforms = PluginProperties.getUserProperties().getProperty("CH.ifa.draw.menutext.platforms")) != null) {
                PLATFORMS_MENU = tmpPlatforms;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DrawPlugin.checkSwing();
    }

    private static void checkSwing() throws PluginException {
        try {
            Toolkit.getDefaultToolkit();
            logger.debug((Object)"DrawPlugin: Swing initialization successful.");
        }
        catch (Throwable e) {
            logger.debug((Object)("DrawPlugin: Swing initialization failed: " + String.valueOf(e)));
            throw new PluginException("Could not initialize Swing, disabling DrawPlugin.", e);
        }
    }

    public void init() {
        DrawPlugin.usePatchingStorableInput();
        GUIProperties.setProperties((Properties)this._properties);
        this.importHolder = new ImportHolderImpl();
        this.exportHolder = new ExportHolderImpl();
        this.setRecentlySavedMenu(new CommandMenu("Recently saved"));
        File file = this.readRecentlySavedFileList();
        this.recentFilesModificationDate = file.lastModified();
        MenuManager menuManager = MenuManager.getInstance();
        JMenu menu = menuManager.createTopLevelMenu(FILE_MENU, 0);
        menuManager.createTopLevelMenu(EDIT_MENU, 1);
        menuManager.createTopLevelMenu(LAYOUT_MENU, 1);
        menuManager.createTopLevelMenu(ATTRIBUTES_MENU, 1);
        this.registerMenuItems(FILE_MENU, new FileMenuCreator().createMenus(this.importHolder, this.exportHolder, this.getRecentlySavedMenu()));
        this.registerMenuItems(EDIT_MENU, new EditMenuCreator().createMenus());
        this.registerMenuItems(LAYOUT_MENU, new AlignmentMenuCreator().createMenus());
        this.registerMenuItems(ATTRIBUTES_MENU, new AttributesMenuCreator().createMenus());
        menuManager.createTopLevelMenu("Windows ", 5);
        this.registerMenuItems("Windows ", new WindowsMenuCreator().createMenus());
    }

    private File readRecentlySavedFileList() {
        File dir = PluginManager.getPreferencesLocation();
        File file = new File(dir, RECENTLY_SAVED);
        this.recentFiles = new ArrayList();
        if (file.exists()) {
            Drawing drawing = DrawingFileHelper.loadDrawing(file, null);
            this.putRecentFileNamesInList(drawing);
            this.updateRecentFileMenu();
        } else {
            StandardDrawing drawing = new StandardDrawing();
            DrawingFileHelper.saveDrawing(drawing, file, null);
        }
        return file;
    }

    public void updateRecentlySavedList(String filename) {
        assert (this.recentFiles != null) : "Error: recent file list should not be null.";
        File recentlySavedFiles = new File(PluginManager.getPreferencesLocation(), RECENTLY_SAVED);
        if (recentlySavedFiles.lastModified() > this.recentFilesModificationDate) {
            this.readRecentlySavedFileList();
        }
        this.putOneFileNameInListOfRecentFiles(filename);
        StandardDrawing recent = new StandardDrawing();
        int offset = 0;
        for (String name : this.recentFiles) {
            TextFigure tf = new TextFigure(name);
            recent.add(tf);
            tf.moveBy(0, offset);
            offset += 20;
        }
        DrawingFileHelper.saveDrawing(recent, recentlySavedFiles, null);
        this.recentFilesModificationDate = recentlySavedFiles.lastModified();
        this.updateRecentFileMenu();
    }

    private void putOneFileNameInListOfRecentFiles(String filename) {
        this.recentFiles.remove(filename);
        this.recentFiles.add(0, filename);
        int num = PluginProperties.getUserProperties().getIntProperty(NUM_RECENT_FILES_KEY, 10);
        if (this.recentFiles.size() > num) {
            this.recentFiles.retainAll(this.recentFiles.subList(0, num));
        }
    }

    private void putRecentFileNamesInList(Drawing recent) {
        FigureEnumeration figures = recent.figuresReverse();
        while (figures.hasMoreElements()) {
            TextFigure tf = (TextFigure)figures.nextElement();
            File file = new File(tf.getText());
            if (!file.exists()) continue;
            this.recentFiles.add(0, tf.getText());
        }
    }

    private void updateRecentFileMenu() {
        Iterator<String> it = this.recentFiles.iterator();
        this.getRecentlySavedMenu().removeAll();
        int i = 0;
        while (it.hasNext()) {
            String recentFileName = it.next();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(DrawPlugin.class.getName() + ": Putting " + recentFileName + " into 'Recently saved' menu."));
            }
            if (!this.getProperties().getBoolProperty(SHOW_RECENTLY_SAVED_HOTKEYS_KEY) || i > 9) {
                this.getRecentlySavedMenu().add(new OpenDrawingCommand(recentFileName, StringUtil.getFilename((String)recentFileName)));
                continue;
            }
            this.getRecentlySavedMenu().add(new OpenDrawingCommand(recentFileName, StringUtil.getFilename((String)recentFileName)), keys[i++], Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() + 512);
        }
    }

    private void registerMenuItems(String menu, Collection<JMenuItem> items) {
        Iterator<JMenuItem> it = items.iterator();
        MenuManager menuManager = MenuManager.getInstance();
        while (it.hasNext()) {
            JMenuItem item = it.next();
            if (item.getClientProperty("ch.ifa.draw.menu.id") == null) {
                item.putClientProperty("ch.ifa.draw.menu.id", "CH.ifa.draw." + menu + "." + item.getText());
            }
            menuManager.registerMenu(menu, item);
        }
    }

    @Provides
    public IOHelper getIOHelper() {
        return IOHelper.getInstance();
    }

    @Deprecated(since="5.0", forRemoval=true)
    @Provides
    public ImportHolder getImportHolder() {
        return this.importHolder;
    }

    @Deprecated(since="5.0", forRemoval=true)
    @Provides
    public ExportHolder getExportHolder() {
        return this.exportHolder;
    }

    public static DrawPlugin getCurrent() {
        for (Object o : PluginManager.getInstance().getPluginsProviding("ch.ifa.draw")) {
            if (!(o instanceof DrawPlugin)) continue;
            return (DrawPlugin)((Object)o);
        }
        return null;
    }

    public static DrawPlugin getCurrentDrawPlugin() throws IllegalStateException {
        for (Object o : PluginManager.getInstance().getPluginsProviding("ch.ifa.draw")) {
            if (!(o instanceof DrawPlugin)) continue;
            return (DrawPlugin)((Object)o);
        }
        throw new IllegalStateException("DrawPlugin was accessed before it was loaded.");
    }

    @Provides
    public MenuManager getMenuManager() {
        return MenuManager.getInstance();
    }

    @Provides
    @Deprecated
    public DrawingEditor getDrawingEditor() {
        DrawingEditor result = null;
        DrawApplication gui = DrawPlugin.getGui();
        result = gui == null ? EditorApi.getNullDrawingEditor() : gui;
        return result;
    }

    @Deprecated
    public void showStatus(String status) throws NoGuiAvailableException {
        if (!this.isGuiPresent()) {
            throw new NoGuiAvailableException("DrawPlugin: cannot show status: no gui window.");
        }
        EventQueue.invokeLater(() -> {
            DrawApplication gui = DrawPlugin.getGui();
            if (gui != null) {
                gui.showStatus(status);
            }
        });
    }

    public boolean isGuiPresent() {
        return _gui != null;
    }

    public void setRecentlySavedMenu(CommandMenu recentlySavedMenu) {
        this.recentlySavedMenu = recentlySavedMenu;
    }

    public CommandMenu getRecentlySavedMenu() {
        return this.recentlySavedMenu;
    }

    @Deprecated(since="5.0", forRemoval=true)
    public static void patchStorableInput() {
        DrawPlugin.usePatchingStorableInput();
    }

    private static void usePatchingStorableInput() {
        DrawingFileHelper.setStorableInputDrawingLoader(new StorableInputDrawingLoader(){

            @Override
            protected StorableInput makeStorableInput(URL location, boolean useUTF) throws IOException {
                return StorableApi.createPatchingStorableInput(location, useUTF);
            }
        });
    }

    static {
        PLUGINS_MENU = "Plugins";
        PLATFORMS_MENU = null;
        keys = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 48};
    }
}

