/*
 * Decompiled with CFR 0.152.
 */
package de.renew.export.io.exportFormats;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.exporting.AbstractDrawingExportFormat;
import de.renew.export.io.exportFormats.ExportPlugin;
import de.renew.io.api.FileApi;
import de.renew.ioontology.FileFilter;
import de.renew.ioontology.FileType;
import de.renew.plugin.PluginProperties;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.File;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.freehep.graphicsbase.util.UserProperties;
import org.freehep.graphicsio.pdf.PDFGraphics2D;

public class PDFExportFormat
extends AbstractDrawingExportFormat {
    public static final Logger LOGGER = Logger.getLogger(PDFExportFormat.class);
    public static final String PDF_EXPORT_HOTKEY_PROP_NAME = "de.renew.hotkeymap.export.exportcurrentdrawingpdf";
    private PluginProperties _plugincfg;

    public PDFExportFormat() {
        super("PDF", (FileFilter)FileApi.createExtensionFileFilter((FileType)FileType.PDF));
    }

    public PDFExportFormat(PluginProperties plugincfg) {
        super("PDF", (FileFilter)FileApi.createExtensionFileFilter((FileType)FileType.PDF));
        this._plugincfg = plugincfg;
    }

    public boolean canExportNto1() {
        return false;
    }

    public File export(Drawing[] drawings, File path) throws Exception {
        File result = null;
        assert (result != null) : "Failure in PDFExportFormat: result == null";
        return result;
    }

    public File export(Drawing drawing, File file) throws Exception {
        Rectangle bounds = drawing.getBounds();
        return this.internalExport(drawing, file, bounds);
    }

    public File internalExport(Drawing drawing, File path, Rectangle bounds) throws Exception {
        File result = null;
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        int height = bounds.height;
        Dimension d = new Dimension(width, height);
        PDFGraphics2D graphics = new PDFGraphics2D(path, d);
        String pageSize = "BoundingBox";
        String pageOrientation = "Portrait";
        ExportPlugin plugin = ExportPlugin.getCurrent();
        if (plugin != null) {
            pageSize = plugin.getPageSize();
            pageOrientation = plugin.getPageOrientation();
        }
        UserProperties defaultProperties = new UserProperties();
        if (pageSize.equals("BoundingBox")) {
            defaultProperties.setProperty(PDFGraphics2D.PAGE_SIZE, PDFGraphics2D.CUSTOM_PAGE_SIZE);
            defaultProperties.setProperty(PDFGraphics2D.CUSTOM_PAGE_SIZE, d);
            defaultProperties.setProperty(PDFGraphics2D.PAGE_MARGINS, new Insets(0, 0, 0, 0));
        } else {
            defaultProperties.setProperty(PDFGraphics2D.PAGE_SIZE, pageSize);
            defaultProperties.setProperty(PDFGraphics2D.ORIENTATION, pageOrientation);
        }
        graphics.setProperties((Properties)defaultProperties);
        graphics.startExport();
        graphics.translate(-x, -y);
        graphics.clipRect(x, y, width, height);
        drawing.draw((Graphics)graphics);
        graphics.endExport();
        result = path;
        assert (result != null) : "Failure in PDFExportFormat: result == null";
        return result;
    }

    public boolean canExportDrawing(Drawing drawing) {
        return true;
    }

    public int getModifier() {
        if (this._plugincfg != null) {
            return PluginProperties.getUserProperties().getHotkeyProperty(PDF_EXPORT_HOTKEY_PROP_NAME, this._plugincfg.getHotkeyProperty(PDF_EXPORT_HOTKEY_PROP_NAME)).getModifiers();
        }
        return PluginProperties.getUserProperties().getHotkeyProperty(PDF_EXPORT_HOTKEY_PROP_NAME).getModifiers();
    }

    public int getShortCut() {
        if (this._plugincfg != null) {
            return PluginProperties.getUserProperties().getHotkeyProperty(PDF_EXPORT_HOTKEY_PROP_NAME, this._plugincfg.getHotkeyProperty(PDF_EXPORT_HOTKEY_PROP_NAME)).getKeyCode();
        }
        return PluginProperties.getUserProperties().getHotkeyProperty(PDF_EXPORT_HOTKEY_PROP_NAME).getKeyCode();
    }
}

