/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.edit;

import de.renew.refactoring.edit.Editor;
import de.renew.refactoring.util.ProgressCalculator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class IteratorEditor<T, R>
implements Editor<R> {
    private static final Logger LOGGER = Logger.getLogger(IteratorEditor.class);
    private final int _numberOfEdits;
    private final Iterator<T> _edits;
    private int _numberOfPerformedEdits;
    private T _currentEdit;

    public IteratorEditor(Iterator<T> edits, int numberOfEdits) {
        LOGGER.debug((Object)("Edits: " + String.valueOf(edits)));
        this._edits = edits;
        this._numberOfEdits = numberOfEdits;
    }

    public IteratorEditor(List<T> edits) {
        this(edits.iterator(), edits.size());
    }

    @Override
    public int getNumberOfEdits() {
        return this._numberOfEdits;
    }

    @Override
    public boolean hasNextEdit() {
        return this._edits.hasNext();
    }

    @Override
    public int getProgress() {
        return ProgressCalculator.calculateProgress(this._numberOfPerformedEdits, this._numberOfEdits);
    }

    @Override
    public String getCurrentEditString() {
        return this._currentEdit.toString();
    }

    @Override
    public R performNextEdit() {
        ++this._numberOfPerformedEdits;
        this._currentEdit = this._edits.next();
        return this.performEdit(this._currentEdit);
    }

    protected abstract R performEdit(T var1);

    @Override
    public List<R> performAllEdits() {
        ArrayList<R> result = new ArrayList<R>();
        while (this.hasNextEdit()) {
            result.add(this.performNextEdit());
        }
        return result;
    }

    protected T getCurrentEdit() {
        return this._currentEdit;
    }
}

