/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.nin;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.TransitionFigure;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PTCNetInformation {
    private Map<TransitionFigure, String> initialUplinkTransitions;
    private Map<TransitionFigure, String> initialDownlinkTransitions;
    private Collection<ArcConnection> initialArcFigures;
    private Map<ArcConnection, CPNTextFigure> initialArcInscriptions;
    private Map<TransitionFigure, CPNTextFigure> initialTransitionInscriptions;

    public PTCNetInformation(Drawing ptc_netdrawing) {
        this.extractFigures(ptc_netdrawing);
    }

    private void extractFigures(Drawing netdrawing) {
        this.initialArcFigures = new HashSet<ArcConnection>();
        this.initialArcInscriptions = new HashMap<ArcConnection, CPNTextFigure>();
        this.initialTransitionInscriptions = new HashMap<TransitionFigure, CPNTextFigure>();
        this.initialUplinkTransitions = new HashMap<TransitionFigure, String>();
        this.initialDownlinkTransitions = new HashMap<TransitionFigure, String>();
        FigureEnumeration enumerator = netdrawing.figures();
        while (enumerator.hasMoreElements()) {
            Figure fig = enumerator.nextFigure();
            if (fig instanceof ArcConnection) {
                this.initialArcFigures.add((ArcConnection)fig);
                continue;
            }
            if (!(fig instanceof CPNTextFigure)) continue;
            CPNTextFigure text = (CPNTextFigure)fig;
            if (text.getType() == 1 && text.parent() instanceof ArcConnection) {
                this.initialArcInscriptions.put((ArcConnection)text.parent(), text);
            }
            if (text.getType() != 1 || !(text.parent() instanceof TransitionFigure)) continue;
            this.initialTransitionInscriptions.put((TransitionFigure)text.parent(), text);
            Matcher matcher = this.parseChannelInscription(text);
            if (matcher == null) continue;
            if (matcher.group(1).isBlank()) {
                this.initialUplinkTransitions.put((TransitionFigure)text.parent(), matcher.group(2));
                continue;
            }
            this.initialDownlinkTransitions.put((TransitionFigure)text.parent(), matcher.group(2));
        }
    }

    private Matcher parseChannelInscription(CPNTextFigure textFigure) {
        Pattern pattern = Pattern.compile("(.*):(.*)\\(.*\\)");
        Matcher m = pattern.matcher(textFigure.getText());
        if (m.find()) {
            return m;
        }
        return null;
    }

    public Set<ArcConnection> getOutgoingArcs(TransitionFigure fig) {
        HashSet<ArcConnection> arcs = new HashSet<ArcConnection>();
        for (ArcConnection arc : this.initialArcFigures) {
            if (arc.startFigure() != fig) continue;
            arcs.add(arc);
        }
        return arcs;
    }

    public Set<ArcConnection> getIncomingArcs(TransitionFigure fig) {
        HashSet<ArcConnection> arcs = new HashSet<ArcConnection>();
        for (ArcConnection arc : this.initialArcFigures) {
            if (arc.endFigure() != fig) continue;
            arcs.add(arc);
        }
        return arcs;
    }

    public Map<TransitionFigure, String> getInitialUplinkTransitions() {
        return this.initialUplinkTransitions;
    }

    public Map<TransitionFigure, String> getInitialDownlinkTransitions() {
        return this.initialDownlinkTransitions;
    }

    public Map<ArcConnection, CPNTextFigure> getInitialArcInscriptions() {
        return this.initialArcInscriptions;
    }

    public Map<TransitionFigure, CPNTextFigure> getInitialTransitionInscriptions() {
        return this.initialTransitionInscriptions;
    }
}

