/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.TextHolder;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNDrawingLoader;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.FigureCreator;
import de.renew.gui.ModeReplacement;
import de.renew.net.NetInstance;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.ObjectAccessor;
import java.rmi.RemoteException;

class NetInstanceFigureCreator
implements FigureCreator {
    NetInstanceFigureCreator() {
    }

    @Override
    public Figure getTokenFigure(ObjectAccessor token, boolean expanded) throws RemoteException {
        NetInstanceAccessor instance = token.asNetInstance();
        CPNDrawing drawing = null;
        Figure iconFigure = null;
        CPNDrawingLoader drawingLoader = ModeReplacement.getInstance().getDrawingLoader();
        if (drawingLoader != null) {
            drawing = drawingLoader.getDrawing(instance.getNet().asString());
        }
        if (drawing != null) {
            iconFigure = drawing.getIconFigure();
        }
        if (iconFigure != null) {
            iconFigure = (Figure)iconFigure.clone();
            this.updateID(iconFigure, instance);
            return iconFigure;
        }
        return null;
    }

    @Override
    public boolean canCreateFigure(ObjectAccessor token, boolean expanded) throws RemoteException {
        return token != null && token.isInstanceOf(NetInstance.class);
    }

    private void updateID(Figure figure, NetInstanceAccessor instance) {
        if (figure instanceof TextHolder) {
            TextHolder textFig = (TextHolder)figure;
            textFig.setReadOnly(true);
            textFig.setText(CPNInstanceDrawing.expandMacro(textFig.getText(), instance));
        } else if (figure instanceof CompositeFigure) {
            FigureEnumeration figenumeration = figure.figures();
            while (figenumeration.hasMoreElements()) {
                this.updateID(figenumeration.nextFigure(), instance);
            }
        }
    }
}

