/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.TextFigure;
import de.renew.draw.storables.ontology.Figure;
import de.renew.gui.FigureCreator;
import de.renew.gui.GuiPlugin;
import de.renew.gui.HorizontalCompositeFigure;
import de.renew.gui.NetInstanceHandle;
import de.renew.net.NetInstance;
import de.renew.plugin.PropertyHelper;
import de.renew.remote.ObjectAccessor;
import de.renew.util.TextToken;
import java.awt.Color;
import java.awt.Graphics;
import java.rmi.RemoteException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class MultipleTokenFigure
extends HorizontalCompositeFigure {
    private static final Logger logger = Logger.getLogger(MultipleTokenFigure.class);
    public static final String NOTOKENBACKGROUND_PROP_NAME = "de.renew.gui.noTokenBackground";

    public MultipleTokenFigure(int mult, boolean isTested, double time, ObjectAccessor token, boolean expanded) {
        String multStr = MultipleTokenFigure.getMultString(mult, isTested);
        if (!multStr.isEmpty()) {
            this.add((Figure)new TextFigure(multStr, true));
        }
        try {
            FigureCreator fc = GuiPlugin.getCurrent().getFigureCreator();
            Figure tokenFig = fc.getTokenFigure(token, expanded);
            this.add(tokenFig);
            if (token != null && token.isInstanceOf(NetInstance.class)) {
                this.addClickHandle(new NetInstanceHandle(tokenFig, null, token.asNetInstance()));
            }
        }
        catch (RemoteException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (time != 0.0) {
            this.add((Figure)new TextFigure("@" + time, true));
        }
        this.layout();
    }

    public static String objectToString(Object token) {
        StringBuilder output = new StringBuilder();
        if (token instanceof String) {
            output.append('\"').append((String)token).append('\"');
        } else if (token instanceof TextToken) {
            output.append(((TextToken)token).toTokenText());
        } else {
            output.append(token);
        }
        return output.toString();
    }

    public static String getMultString(int mult, boolean isTested) {
        StringBuilder output = new StringBuilder();
        if (isTested) {
            if (mult > 0) {
                output.append(mult);
            }
            output.append("(1)");
        } else if (mult > 1) {
            output.append(mult);
        }
        if (isTested || mult > 1) {
            output.append("'");
        }
        return output.toString();
    }

    public Figure findFigure(int x, int y) {
        return null;
    }

    public void draw(Graphics g) {
        if (!PropertyHelper.getBoolProperty((Properties)GuiPlugin.getCurrent().getProperties(), (String)NOTOKENBACKGROUND_PROP_NAME)) {
            g.setColor(Color.WHITE);
            g.drawRect(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
            g.fillRect(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
        }
        super.draw(g);
    }
}

