/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.application.NoGuiAvailableException;
import CH.ifa.draw.standard.InfoDialog;
import de.renew.application.SimulatorExtensionAdapter;
import de.renew.draw.storables.api.StorableApi;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.ui.api.EditorApi;
import de.renew.draw.ui.api.MenuApi;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.draw.ui.ontology.ErrorState;
import de.renew.draw.ui.ontology.StatusDisplayer;
import de.renew.gui.AggregateFigureCreator;
import de.renew.gui.BreakpointManager;
import de.renew.gui.CPNApplication;
import de.renew.gui.CPNDrawingEditor;
import de.renew.gui.ConfigureSimulationTabController;
import de.renew.gui.Demonstrator;
import de.renew.gui.EditorCreatedEvent;
import de.renew.gui.EditorCreatedListener;
import de.renew.gui.FigureCreator;
import de.renew.gui.FigureCreatorComposition;
import de.renew.gui.FigureCreatorHolder;
import de.renew.gui.FigureExceptionFactory;
import de.renew.gui.GuiPalettes;
import de.renew.gui.LocalFigureFigureCreator;
import de.renew.gui.ModeReplacement;
import de.renew.gui.NetInstanceFigureCreator;
import de.renew.gui.NetMenuCreator;
import de.renew.gui.PaletteHolder;
import de.renew.gui.SimulationMenuCreator;
import de.renew.gui.StartGuiCommand;
import de.renew.gui.SyntaxExceptionFrame;
import de.renew.gui.TextFigureCreator;
import de.renew.gui.TokenFigureCreator;
import de.renew.gui.configure.ConfigureEngineController;
import de.renew.gui.configure.ConfigureNetpathController;
import de.renew.gui.configure.ConfigureRemoteAccessController;
import de.renew.gui.menu.AlignmentMenuExtender;
import de.renew.gui.menu.AttributesMenuExtender;
import de.renew.gui.menu.EditMenuExtender;
import de.renew.gui.menu.HelpMenuCreator;
import de.renew.io.exportFormats.SNSExportFormat;
import de.renew.io.exportFormats.WoflanExportFormat;
import de.renew.io.exportFormats.XMLExportFormat;
import de.renew.io.importFormats.SNSImportFormat;
import de.renew.io.importFormats.XMLImportFormat;
import de.renew.ioontology.exporting.ExportFormat;
import de.renew.ioontology.importing.ImportFormat;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.annotations.Inject;
import de.renew.plugin.command.CLCommand;
import de.renew.plugin.di.DIPlugin;
import de.renew.remote.NetInstanceAccessor;
import de.renew.simulator.api.SimulatorExtensions;
import de.renew.simulatorontology.shadow.SyntaxException;
import de.renew.simulatorontology.simulation.SimulationEnvironment;
import de.renew.simulatorontology.simulation.SimulatorExtension;
import de.renew.windowmanagement.Workbench;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class GuiPlugin
extends DIPlugin
implements StatusDisplayer {
    private static final Logger logger = Logger.getLogger(GuiPlugin.class);
    public static final String MENU_PREFIX = "de.renew.gui";
    public static final String SIMULATION_MENU = "Simulation";
    public static final String NET_MENU = "Net";
    public static final String VERIFICATION_MENU = "Verification";
    public static final String VIRTUAL_TRANSITION = "de.renew.gui.virtualTransition";
    private SyntaxExceptionFrame syntaxFrame = null;
    private final Collection<String> _menus = new ArrayList<String>();
    private final GuiPalettes paletteManager;
    private CPNApplication _gui;
    private final FigureCreatorComposition _figureCreator = new FigureCreatorComposition();
    private SimulationStateListener _simulationListener = null;
    private final List<ConfigureSimulationTabController> _simConfigTabControllers = new Vector<ConfigureSimulationTabController>();
    public static final String SHUTDOWN_PROP_NAME = "de.renew.gui.shutdownOnClose";
    public static final String AUTOSTART_PROP_NAME = "de.renew.gui.autostart";
    public static final String USE_VERIFICATION_MENU_PROP_NAME = "de.renew.gui.verificationMenu";
    private BreakpointManager bpManager = null;
    private final Workbench fWorkbench;
    private final transient Vector<EditorCreatedListener> _editorCreatedListeners;

    @Inject
    public GuiPlugin(Workbench workbench) {
        this.fWorkbench = workbench;
        this.paletteManager = new GuiPalettes(workbench, this);
        this._editorCreatedListeners = new Vector();
    }

    public void init() {
        logger.debug((Object)"initializing GUI plugin.");
        this._simulationListener = new SimulationStateListener();
        Collection<JMenuItem> alignmentMenus = new AlignmentMenuExtender().createMenus();
        Collection<JMenuItem> attributeMenus = new AttributesMenuExtender().createMenus();
        Collection<JMenuItem> editMenus = new EditMenuExtender().createMenus();
        Collection<JMenuItem> simMenus = new SimulationMenuCreator().createMenus(this.getBreakpointManager());
        Collection<JMenuItem> netMenus = new NetMenuCreator().createMenus(this.getBreakpointManager());
        Collection<JMenuItem> helpMenus = new HelpMenuCreator().createMenus();
        MenuManager menuManager = MenuManager.getInstance();
        JMenu menu = menuManager.createTopLevelMenu(NET_MENU, 2);
        menuManager.createTopLevelMenu(SIMULATION_MENU, 2);
        menuManager.createTopLevelMenu(MenuApi.getMenuNameHelpMenu(), 6);
        this.registerMenuItems(NET_MENU, netMenus);
        this.registerMenuItems(SIMULATION_MENU, simMenus);
        this.registerMenuItems(MenuApi.getMenuNameHelpMenu(), helpMenus);
        this.registerMenuItems(MenuApi.getMenuNameLayoutMenu(), alignmentMenus);
        this.registerMenuItems(MenuApi.getMenuNameAttributesMenu(), attributeMenus);
        this.registerMenuItems(MenuApi.getMenuNameEditMenu(), editMenus);
        this.registerCreators();
        SimulatorExtensions.addExtension((SimulatorExtension)this._simulationListener);
        this.initDefaultImportFormats();
        this.initDefaultExportFormats();
        PluginManager manager = PluginManager.getInstance();
        manager.addCLCommand("gui", (CLCommand)new StartGuiCommand(this));
        manager.addCLCommand("demonstrator", (CLCommand)new Demonstrator());
        if (this.getProperties().getBoolProperty(AUTOSTART_PROP_NAME)) {
            ((CLCommand)manager.getCLCommands().get("gui")).execute(new String[0], System.out);
        }
        this._simConfigTabControllers.add(new ConfigureEngineController());
        this._simConfigTabControllers.add(new ConfigureRemoteAccessController());
        this._simConfigTabControllers.add(new ConfigureNetpathController());
    }

    @Deprecated(since="5.0", forRemoval=true)
    public static void patchStorableInput() {
        DrawPlugin.patchStorableInput();
    }

    private void registerMenuItems(String menu, Collection<JMenuItem> items) {
        MenuManager menuManager = MenuManager.getInstance();
        for (JMenuItem item : items) {
            if (item != null) {
                String id = "de.renew.gui." + item.getText();
                this._menus.add(id);
                menuManager.registerMenu(menu, item, id);
                continue;
            }
            logger.warn((Object)("GuiPlugin.registerMenuItems: Could not register " + menu + ". No parent menu found."));
        }
    }

    public synchronized boolean cleanup() {
        for (String menu : this._menus) {
            DrawPlugin.getCurrent().getMenuManager().unregisterMenu(menu);
        }
        if (this.isGuiPresent()) {
            GuiPlugin.doSynchronized(() -> this._gui.exit());
        }
        Demonstrator.cleanup();
        if (this._simulationListener != null) {
            SimulatorExtensions.removeExtension((SimulatorExtension)this._simulationListener);
            this._simulationListener = null;
        }
        PluginManager.getInstance().removeCLCommand("gui");
        PluginManager.getInstance().removeCLCommand("demonstrator");
        return true;
    }

    public synchronized boolean canShutDown() {
        if (this.isGuiPresent()) {
            class GuiQuery
            implements Runnable {
                public boolean exitOK = false;

                GuiQuery() {
                }

                @Override
                public void run() {
                    this.exitOK = GuiPlugin.this._gui.canClose();
                }
            }
            GuiQuery guiQuery = new GuiQuery();
            logger.debug((Object)"asking gui to allow close operation");
            GuiPlugin.doSynchronized(guiQuery);
            return guiQuery.exitOK;
        }
        return true;
    }

    private static void doSynchronized(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("GuiPlugin: synchronised operation has been interrupted.", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("GuiPlugin: synchronised operation has failed.", e.getTargetException());
            }
        }
    }

    public static GuiPlugin getCurrent() {
        for (IPlugin o : PluginManager.getInstance().getPluginsProviding(MENU_PREFIX)) {
            if (!(o instanceof GuiPlugin)) continue;
            return (GuiPlugin)o;
        }
        return null;
    }

    public ConfigureSimulationTabController[] getConfigTabController() {
        return this._simConfigTabControllers.toArray(new ConfigureSimulationTabController[0]);
    }

    public void addConfigTabController(ConfigureSimulationTabController tabController) {
        this._simConfigTabControllers.add(tabController);
    }

    public void removeConfigTabController(ConfigureSimulationTabController tabController) {
        this._simConfigTabControllers.remove(tabController);
    }

    public synchronized void openGui() {
        if (!this.isGuiPresent()) {
            GuiPlugin pluginInstance = this;
            Workbench workbench = this.fWorkbench;
            GuiPlugin.doSynchronized(() -> {
                logger.debug((Object)("GuiPlugin: Starting gui. Classloader is " + String.valueOf(((Object)((Object)this)).getClass().getClassLoader())));
                workbench.openGui();
                CPNDrawingEditor editor = new CPNDrawingEditor(pluginInstance, workbench);
                this.notifyEditorCreatedListeners(editor);
                new CPNApplication(new String[0], pluginInstance, workbench, editor);
            });
        }
        this.paletteManager.notifyGuiOpen();
        assert (this.isGuiPresent()) : "Gui should run after opening.";
    }

    void notifyGuiStart(CPNApplication c) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called in the AWT event thread.";
        assert (!this.isGuiPresent()) : "Must be called exactly once.";
        assert (c != null) : "Must be called by the gui instance.";
        logger.debug((Object)(String.valueOf((Object)this) + " blocking exit."));
        PluginManager.getInstance().blockExit((IPlugin)this);
        this._gui = c;
    }

    boolean isShutdownOnClose() {
        return this.getProperties().getBoolProperty(SHUTDOWN_PROP_NAME);
    }

    void doShutdownOnClose() {
        PluginManager.getInstance().stop();
    }

    void notifyGuiClosed(CPNApplication c) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called in the AWT event thread.";
        assert (this._gui == c) : "Must be called by the current gui instance";
        this._gui = null;
        logger.debug((Object)(String.valueOf((Object)this) + " releasing exit block."));
        PluginManager.getInstance().exitOk((IPlugin)this);
        ModeReplacement.killInstance();
    }

    public synchronized void closeGui() {
        if (this.isGuiPresent()) {
            GuiPlugin.doSynchronized(() -> {
                this._gui.requestClose();
                if (!this.isGuiPresent()) {
                    this._editorCreatedListeners.clear();
                }
            });
        }
        this.bpManager = null;
    }

    public CPNApplication getGui() {
        return this._gui;
    }

    public DrawingEditor getDrawingEditor() {
        CPNApplication gui = GuiPlugin.getCurrentGui();
        Object result = gui == null ? EditorApi.getNullDrawingEditor() : gui;
        return result;
    }

    public boolean isGuiPresent() {
        return this._gui != null;
    }

    public JFrame getGuiFrame() {
        CPNApplication site = this.getGui();
        if (site != null) {
            return site.getFrame();
        }
        logger.error((Object)"GuiPlugin: no gui to get frame!");
        return null;
    }

    private static CPNApplication getCurrentGui() {
        GuiPlugin current = GuiPlugin.getCurrent();
        if (current == null) {
            logger.error((Object)"GuiPlugin: no GuiPlugin available.");
            return null;
        }
        return current._gui;
    }

    public PaletteHolder getPaletteHolder() {
        return this.paletteManager;
    }

    @Deprecated
    public Drawing openDrawing(Drawing drawing) {
        if (this.isGuiPresent()) {
            return this._gui.openDrawing(drawing);
        }
        throw new NoGuiAvailableException("Cannot create new drawing: no gui window.");
    }

    public synchronized void openInstanceDrawing(NetInstanceAccessor net) throws NoGuiAvailableException {
        if (net == null) {
            throw new NullPointerException("Net instance may not be null.");
        }
        if (!this.isGuiPresent()) {
            throw new NoGuiAvailableException("GuiPlugin: no gui to open net instance!");
        }
        GuiPlugin.doSynchronized(() -> this.getGui().openInstanceDrawing(net));
    }

    public void showStatus(String status) throws NoGuiAvailableException {
        if (!this.isGuiPresent()) {
            throw new NoGuiAvailableException("GuiPlugin: cannot show status: no gui window.");
        }
        EventQueue.invokeLater(() -> {
            CPNApplication gui = GuiPlugin.getCurrentGui();
            if (gui != null) {
                gui.showStatus(status);
            }
        });
    }

    public InfoDialog createAboutBox() {
        JFrame owner = null;
        if (this.isGuiPresent()) {
            owner = this.getGui().getFrame();
        }
        PluginProperties guiProperties = GuiPlugin.getCurrent().getProperties();
        String title = this.getAboutProperty(guiProperties, "title");
        String version = this.getAboutProperty(guiProperties, "version");
        String content = this.getAboutProperty(guiProperties, "content");
        String revisionTmp = this.getAboutProperty(guiProperties, "revision");
        String addRenewLinkTmp = this.getAboutProperty(guiProperties, "enableLinks");
        int revision = 0;
        if (revisionTmp != null) {
            try {
                revision = Integer.parseInt(revisionTmp);
            }
            catch (NumberFormatException e) {
                logger.warn((Object)("Revision has wrong format: " + revisionTmp), (Throwable)e);
            }
        }
        String message = version + content + (String)(revision > 0 ? "\nRevision" + revision : "");
        boolean addRenewLink = false;
        if (addRenewLinkTmp != null) {
            addRenewLink = Boolean.valueOf(addRenewLinkTmp);
        }
        return new InfoDialog(owner, title, message, addRenewLink);
    }

    private String getAboutProperty(PluginProperties properties, String key) {
        return properties.getProperty("de.renew.help." + key, properties.getProperty("de.renew.help.gui." + key));
    }

    public void bringMenuFrameToFront() {
        if (this.isGuiPresent()) {
            EventQueue.invokeLater(() -> {
                JFrame owner = this.getGui().getFrame();
                if (owner != null) {
                    owner.setVisible(true);
                    owner.toFront();
                }
            });
        }
    }

    public DrawingView getView(Drawing drawing) {
        if (!this.isGuiPresent()) {
            throw new NoGuiAvailableException("GuiPlugin: no view for " + String.valueOf(drawing) + ", no gui window open");
        }
        return this._gui.getView(drawing);
    }

    public void handleSyntaxException(SyntaxException e) {
        if (this.isGuiPresent()) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
            this.processSyntaxException(FigureExceptionFactory.createFigureException(e), true);
        } else {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    void processFigureException(ErrorState e, boolean displayImmediately) {
        CPNApplication app;
        if (this.syntaxFrame == null && (app = this.getGui()) != null) {
            this.syntaxFrame = new SyntaxExceptionFrame(app);
        }
        if (this.syntaxFrame != null) {
            this.syntaxFrame.displayException(e, displayImmediately);
        } else {
            logger.error((Object)e.getMessage());
        }
    }

    public void processSyntaxException(ErrorState e, boolean displayImmediately) {
        this.processFigureException(e, displayImmediately);
        this.showStatus("A syntax error occurred.");
    }

    public void closeSyntaxErrorFrame() {
        if (this.syntaxFrame != null) {
            this.syntaxFrame.dispose();
            this.syntaxFrame = null;
        }
    }

    private void registerCreators() {
        this.safeRegisterFigureCreator("de.renew.gui.Token", new TokenFigureCreator());
        this.safeRegisterFigureCreator("de.renew.unify.Aggregate", new AggregateFigureCreator());
        this.safeRegisterFigureCreator("de.renew.remote.NetInstanceAccessor", new NetInstanceFigureCreator());
        this.safeRegisterFigureCreator("de.renew.draw.storables.ontology.Figure", new LocalFigureFigureCreator());
    }

    private void safeRegisterFigureCreator(String className, FigureCreator register) {
        try {
            ClassLoader classLoader = PluginManager.getInstance().getBottomClassLoader();
            Class.forName(className, true, classLoader);
            this._figureCreator.registerCreator(register);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("could not register FigureCreator: " + String.valueOf(e)));
        }
    }

    public FigureCreatorHolder getFigureCreatorHolder() {
        return this._figureCreator;
    }

    public TextFigureCreator getTextFigureCreator() {
        return this._figureCreator;
    }

    public FigureCreator getFigureCreator() {
        return this._figureCreator;
    }

    private void initDefaultImportFormats() {
        StorableApi.addImportFormat((ImportFormat)new SNSImportFormat());
        StorableApi.addImportFormat((ImportFormat)new XMLImportFormat());
    }

    private void initDefaultExportFormats() {
        StorableApi.addExportFormat((ExportFormat)new XMLExportFormat());
        StorableApi.addExportFormat((ExportFormat)new SNSExportFormat());
        StorableApi.addExportFormat((ExportFormat)new WoflanExportFormat());
    }

    public BreakpointManager getBreakpointManager() {
        if (this.bpManager == null) {
            this.bpManager = new BreakpointManager(ModeReplacement.getInstance().getSimulation());
            ModeReplacement.getInstance().getSimulation().setBreakpointManager(this.bpManager);
        }
        return this.bpManager;
    }

    public static ImageIcon getRenewIcon() {
        return new ImageIcon(((Object)((Object)GuiPlugin.getCurrent())).getClass().getResource("/de/renew/gui/images/renew.png"));
    }

    public void addEditorCreatedListener(EditorCreatedListener listener) {
        this._editorCreatedListeners.addElement(listener);
    }

    public void removeEditorCreatedListener(EditorCreatedListener listener) {
        this._editorCreatedListeners.remove(listener);
    }

    private void notifyEditorCreatedListeners(CPNDrawingEditor editor) {
        if (this._editorCreatedListeners != null) {
            this._editorCreatedListeners.forEach(listener -> listener.editorCreated(new EditorCreatedEvent((Object)this, editor)));
        }
    }

    private class SimulationStateListener
    extends SimulatorExtensionAdapter {
        private SimulationStateListener() {
        }

        public void simulationSetup(SimulationEnvironment env) {
            this.enforceMenuUpdate(false);
        }

        public void simulationTerminated() {
            this.enforceMenuUpdate(true);
        }

        private void enforceMenuUpdate(boolean closeSimulationWindows) {
            EventQueue.invokeLater(() -> {
                if (GuiPlugin.this.isGuiPresent()) {
                    GuiPlugin.this._gui.menuStateChanged();
                    if (closeSimulationWindows) {
                        GuiPlugin.this._gui.cleanupSimulationWindows();
                    }
                }
            });
        }
    }
}

