Tools for Curry-Coloured Petri Nets
===================================

The Curry-coloured Petri net formalism and its tool set provide the possibilities
- to model CCPNs (Curry-coloured Petri nets) with Curry inscriptions in the Renew editor environment
- to simulate CCPN models
- to generate a reachability graph for CCPN models
- to integrate the CCPN simulator as a Haskell library into Haskell programs.

While Haskell is used as the implementations language, Curry is used as the inscription language. The main advantage is that CCPN inscriptions are side effect free due to the Curry's functional pureness and the control of side effects by its strong type system. Binding searches are based on the highly optimized Curry evaluation environment of the KiCS2 compiler.

Prerequisites
-------------

Installation for the CCPN tools is supported for Unix-like systems (macOS, Linux, BSD, …) and requires:

- Java Runtime Environment in Version 11 or later
- Git

Installation
------------

The CCPN tool set requires two components, Renew with the CCPN and the RNRG plugin, as well as the CCPN simulator (includes the KiCS2 Curry compiler).

We have extensively tested the installation on macOS, but it also supports other Unix-like systems (Linux, BSD, …). Windows is currently not officially supported (see below).

### Renew

This package contains a precompiled version of Renew and the required plugins. To generate the startup scripts for Renew run the `bin/unix/installrenew` script.

### CCPN Simulator

The CCPN simulator has to be compiled manually. The setup script requires Git to clone the CCPN repository and its dependencies. The script uses the Haskell tool Stack to download and compile all required Haskell libraries. Stack is automatically installed, if it is not already available.

To compile the CCPN simulator and all its dependencies run:

```
sh setup_ccpn.sh
```

This may take a while because it bootstraps the KiCS2 compiler.

### On Windows

So far, we do not offer a working setup script for the CCPN simulator on Windows. The installation described above only works on Unix-like systems (macOS, Linux, BSD, …). The CCPN simulator installation depends on a lot of standard GNU commands that are very difficult to set up correctly in Windows. However, if the CCPN simulator installation succeeded, Renew can be set up in Windows by running `bin/win/installrenew.bat` and then started by running `bin/win/loadrenew`.

Usage
-----

To start Renew with the CCPN plugin use the generated `bin/unix/loadrenew` script.

You can find the example CCPN from the _Tools for Curry-Coloured Petri Nets_ paper in `samples/word.rnw`.
The other examples are from the master thesis.

To select the CCPN simulation formalism click on the menu item _Simulation -> Formalisms -> Curry Net Compiler_.
Subsequently, you can start a concurrent CCPN simulation by _Simulation -> Run Simulation_.
Please note that the CCPN compilation occurs at the beginning of each new simulation and takes some time before the first marking is visualized.
Alternatively, you can start a simulation and fire individual transitions by _Simulation -> Simulation Step_.
A running simulation is halted by _Simulation -> Halt Simulation_ and any simulation is terminated by _Simulation -> Terminate Simulation_.

The colored reachability graph can be generated by _Tools -> Curry Reachability Graph_.
In the generated graph, a graphical representation of a marking is opened by double-clicking it.

### As a Haskell Library

See the _Usage Examples_ in the README of the CCPN simulator's master_thesis_examples branch:
https://git.informatik.uni-hamburg.de/9simon/ccpn/tree/master_thesis_examples

They exceed the scope of the _Tools for Curry-Coloured Petri Nets_ paper, but two of them are explained in the master thesis.

References for CCPN
-------------------

- Michael Simon. Curry-Coloured Petri Nets: A concurrent simulator for Petri nets with purely functional logic program inscriptions. Master thesis, University of Hamburg, Department of Informatics, Vogt-Kölln Str. 30, D-22527 Hamburg, April 2018.

- Michael Simon and Daniel Moldt. About the development of a Curry-Coloured Petri net simulator. In Robert Lorenz and Johannes Metzger, editors, Algorithms and Tools for Petri Nets, Proceedings of the 21th Workshop AWPN 2018, Augsburg, Germany, number 2018-02 in Reports / Technische Berichte der Fakultät für Angewandte Informatik der Universität Augsburg, pages 53–54, 2018.

- Michael Simon, Daniel Moldt, Dennis Schmitz and Michael Haustermann. Tools for Curry-Coloured Petri Nets. In Susanna Donatelli and Stefan Haar, editors, Application and Theory of Petri Nets and Concurrency - 40th International Conference, PETRI NETS 2019, Aachen, Germany, June 23-28, 2019, Proceedings, volume 11522 of Lecture Notes in Computer Science, pages 101-110, 2019.
