/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.locate;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;

public class FileFinder {
    private static final Logger LOGGER = Logger.getLogger(FileFinder.class);

    public static InputStream searchForRnwFileInJars(String netName) {
        String netNameTmp = FileFinder.getContent(netName);
        if (netNameTmp == null) {
            LOGGER.warn((Object)"FileFinder.searchForRnwFileInJars : No net name set.");
            return null;
        }
        List<IPlugin> plugins = PluginManager.getInstance().getPlugins();
        for (IPlugin iPlugin : plugins) {
            InputStream is;
            PluginProperties properties = iPlugin.getProperties();
            if (!properties.getBoolProperty("option.include.rnws") || (is = FileFinder.searchForFileInJar(iPlugin, netNameTmp, "rnw")) == null) continue;
            return is;
        }
        return null;
    }

    public static InputStream searchForFileInJars(String fileName, String extension) {
        String fileNameTmp = FileFinder.getContent(fileName);
        String extensionTmp = FileFinder.getContent(extension);
        if (fileNameTmp == null || extensionTmp == null) {
            if (fileNameTmp == null) {
                LOGGER.warn((Object)"FileFinder.searchForFileInJars : No file name set.");
            }
            if (extensionTmp == null) {
                LOGGER.warn((Object)"FileFinder.searchForFileInJars : No extension set.");
            }
            return null;
        }
        List<IPlugin> plugins = PluginManager.getInstance().getPlugins();
        for (IPlugin iPlugin : plugins) {
            InputStream is = FileFinder.searchForFileInJar(iPlugin, fileNameTmp, extensionTmp);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    public static InputStream getFileFromJarAsStream(URL location, String fileName) {
        try {
            JarFile jarRes = new JarFile(new File(location.toURI()));
            ZipEntry entry = jarRes.getEntry(fileName);
            return entry != null ? jarRes.getInputStream(entry) : null;
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)e);
        }
        return null;
    }

    public static InputStream searchForFileInJar(IPlugin iPlugin, String fileName, String extension) {
        String fileNameTmp = FileFinder.getContent(fileName);
        String extensionTmp = FileFinder.getContent(extension);
        if (iPlugin == null || fileNameTmp == null || extensionTmp == null) {
            if (iPlugin == null) {
                LOGGER.warn((Object)"FileFinder.searchForFileInJar : No plug-in set.");
            }
            if (fileNameTmp == null) {
                LOGGER.warn((Object)"FileFinder.searchForFileInJar : No file name set.");
            }
            if (extensionTmp == null) {
                LOGGER.warn((Object)"FileFinder.searchForFileInJar : No extension set.");
            }
            return null;
        }
        if (extensionTmp.startsWith(".")) {
            extensionTmp = extensionTmp.substring(1);
        }
        if (fileNameTmp.endsWith("." + extensionTmp)) {
            fileNameTmp = fileNameTmp.replace("." + extensionTmp, "");
        }
        try {
            JarFile jarRes = new JarFile(new File(iPlugin.getProperties().getURL().toURI()));
            ZipEntry entry = jarRes.getEntry(fileNameTmp + "." + extensionTmp);
            return entry != null ? jarRes.getInputStream(entry) : null;
        }
        catch (IOException e) {
            LOGGER.error((Object)"FileFinder.searchForFileInJar : IOException ", (Throwable)e);
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)"FileFinder.searchForFileInJar : URISyntaxException ", (Throwable)e);
        }
        return null;
    }

    public static String getURLforFile(String path, String fileName, ClassLoader classLoader) {
        Object pathTmp = FileFinder.getContent(path);
        String fileNameTmp = FileFinder.getContent(fileName);
        if (fileNameTmp == null || classLoader == null) {
            if (fileNameTmp == null) {
                LOGGER.warn((Object)"FileFinder.getURLforFile : No file name set.");
            }
            if (classLoader == null) {
                LOGGER.warn((Object)"FileFinder.getURLforFile : No class loader set.");
            }
            return null;
        }
        if (pathTmp != null && !((String)pathTmp).endsWith("/")) {
            pathTmp = (String)pathTmp + "/";
        }
        if (pathTmp == null) {
            pathTmp = "";
        }
        LOGGER.debug((Object)("FileFinder.getURLforFile: looking for " + (String)pathTmp + fileNameTmp + " ... "));
        URL url = classLoader.getResource((String)pathTmp + fileNameTmp);
        if (url != null) {
            LOGGER.debug((Object)("FileFinder.getURLforFile: found " + String.valueOf(url)));
            return url.toString();
        }
        LOGGER.warn((Object)("FileFinder.getURLforFile: Missing file. Could not locate " + (String)pathTmp + fileNameTmp));
        return null;
    }

    public static List<String> getURLsforFile(String[] paths, String fileName, ClassLoader classLoader) {
        ArrayList<String> urls = new ArrayList<String>();
        String fileNameTmp = FileFinder.getContent(fileName);
        if (fileNameTmp == null || classLoader == null) {
            if (fileNameTmp == null) {
                LOGGER.warn((Object)"FileFinder.getURLsforFile : No file name set.");
            }
            if (classLoader == null) {
                LOGGER.warn((Object)"FileFinder.getURLsforFile : No class loader set.");
            }
            return urls;
        }
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                String url = FileFinder.getURLforFile(paths[i], fileNameTmp, classLoader);
                if (url == null) continue;
                urls.add(url);
            }
        } else {
            String url = FileFinder.getURLforFile(null, fileNameTmp, classLoader);
            if (url != null) {
                urls.add(url);
            }
        }
        return urls;
    }

    private static String getContent(String string) {
        if (string != null && string.trim().length() > 0) {
            return string.trim();
        }
        return null;
    }
}

