/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.command;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.command.CLCommand;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Objects;

public class GetPropertyCommand
implements CLCommand {
    public static final String COMMAND_NAME = "get";

    @Override
    public void execute(String[] args, PrintStream response) {
        if (args.length > 0) {
            if ("-a".equals(args[0])) {
                this.showAllPropertyNames(response);
            } else if ("-A".equals(args[0])) {
                this.showAllProperties(response);
            } else {
                for (String arg : args) {
                    this.getProperty(arg, response);
                }
            }
        }
    }

    private void showAllPropertyNames(PrintStream response) {
        ArrayList<String> propertynames = GetPropertyCommand.getPropertyNames();
        for (String s : propertynames) {
            response.append(s).append("\n");
        }
    }

    private void showAllProperties(PrintStream response) {
        ArrayList<String> propertynames = GetPropertyCommand.getPropertyNames();
        for (String s : propertynames) {
            String[] args = new String[]{s};
            this.execute(args, response);
        }
    }

    public static ArrayList<String> getPropertyNames() {
        ArrayList<String> propertynames = new ArrayList<String>();
        for (IPlugin p : PluginManager.getInstance().getPlugins()) {
            PluginProperties props = p.getProperties();
            Enumeration<Object> en = props.keys();
            while (en.hasMoreElements()) {
                String s = (String)en.nextElement();
                if (propertynames.contains(s)) continue;
                propertynames.add(s);
            }
        }
        Collections.sort(propertynames);
        return propertynames;
    }

    protected void getProperty(String arg, PrintStream response) {
        String globalValue = PluginProperties.getUserProperties().getProperty(arg);
        if (globalValue != null) {
            response.println(arg + " = " + globalValue + " (global value of property)");
        }
        boolean noMatches = true;
        for (IPlugin p : PluginManager.getInstance().getPlugins()) {
            PluginProperties props = p.getProperties();
            String localValue = props.getProperty(arg);
            if (props.isKnownProperty(arg)) {
                if (localValue == null) {
                    response.println("Property " + arg + " is known to plugin " + p.getName() + ", but not set.");
                } else {
                    response.println(arg + " = " + localValue + " (known property in plugin " + p.getName() + ")");
                }
                noMatches = false;
                continue;
            }
            if (Objects.equals(localValue, globalValue)) continue;
            if (localValue == null) {
                response.println("Property " + arg + " is not set locally in plugin " + p.getName() + ".");
            } else {
                response.println(arg + " = " + localValue + " (local value in plugin " + p.getName() + ")");
            }
            noMatches = false;
        }
        if (globalValue == null && noMatches) {
            response.println("Property " + arg + " is not set.");
        }
    }

    @Override
    public String getDescription() {
        return "Returns the value of the given PluginProperty. Options: [-a| -A] for a listing of all known property names / properties.";
    }

    @Override
    public String getArguments() {
        return "propertyNames";
    }
}

