/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin;

import de.renew.plugin.ServiceLookupException;
import de.renew.plugin.jpms.ModuleLayerListener;
import java.lang.module.ModuleDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class ServiceLookupInfrastructure {
    private static final Logger LOGGER = Logger.getLogger(ServiceLookupInfrastructure.class);
    private final Map<Class<?>, List<ModuleLayer>> _providerLocations = new ConcurrentHashMap();
    private final Map<String, Class<?>> _serviceInterfaces = new HashMap();
    private final Map<Module, List<String>> _serviceInterfaceLocations = new HashMap<Module, List<String>>();
    private static final ServiceLookupInfrastructure SLI = new ServiceLookupInfrastructure();

    private ServiceLookupInfrastructure() {
    }

    public static ServiceLookupInfrastructure getInstance() {
        return SLI;
    }

    void addServicesOfModules(Set<Module> modules) {
        for (Module module : modules) {
            this.addServiceInterfacesOfModule(module);
            this.addServiceProvidersOfModule(module);
        }
    }

    public <S> S getFirstServiceProvider(Class<S> service) throws ServiceLookupException {
        List<ModuleLayer> locations = this.getLocationsOfServiceProvider(service);
        if (!locations.isEmpty()) {
            this.ensureAccess(service);
        }
        for (ModuleLayer layer : locations) {
            ServiceLoader<S> loader = ServiceLoader.load(layer, service);
            Iterator<S> it = loader.iterator();
            while (it.hasNext()) {
                try {
                    return it.next();
                }
                catch (ServiceConfigurationError e) {
                    LOGGER.warn((Object)"Couldn't load service provider due to a configuration error.", (Throwable)e);
                }
            }
        }
        throw new ServiceLookupException(service);
    }

    public <S> Collection<S> getAllServiceProvider(Class<S> service) {
        List<ModuleLayer> locations = this.getLocationsOfServiceProvider(service);
        if (!locations.isEmpty()) {
            this.ensureAccess(service);
        }
        HashSet<S> services = new HashSet<S>();
        for (ModuleLayer layer : locations) {
            ServiceLoader<S> loader = ServiceLoader.load(layer, service);
            Iterator<S> it = loader.iterator();
            while (it.hasNext()) {
                try {
                    services.add(it.next());
                }
                catch (ServiceConfigurationError e) {
                    LOGGER.warn((Object)"Couldn't load service provider due to a configuration error.", (Throwable)e);
                }
            }
        }
        return services;
    }

    private void ensureAccess(Class<?> service) {
        Module loader = this.getClass().getModule();
        if (!loader.canUse(service)) {
            loader.addUses(service);
        }
    }

    private Set<String> extractServiceStringsOfModule(Module module) {
        Set<String> usesServiceStrings = module.getDescriptor().uses();
        Set<ModuleDescriptor.Provides> provServiceStrings = module.getDescriptor().provides();
        HashSet<String> serviceStrings = new HashSet<String>();
        for (ModuleDescriptor.Provides serviceString : provServiceStrings) {
            serviceStrings.add(serviceString.service());
        }
        serviceStrings.addAll(usesServiceStrings);
        return serviceStrings;
    }

    private void addServiceInterfacesOfModule(Module module) {
        Set<String> serviceStrings = this.extractServiceStringsOfModule(module);
        for (String serviceString : serviceStrings) {
            try {
                List<Object> value;
                Class<?> serviceInterface = module.getClassLoader().loadClass(serviceString);
                Module serviceInterfaceModule = serviceInterface.getModule();
                if (!this._serviceInterfaces.containsKey(serviceString)) {
                    this._serviceInterfaces.put(serviceString, serviceInterface);
                }
                if (this._serviceInterfaceLocations.containsKey(serviceInterfaceModule)) {
                    value = this._serviceInterfaceLocations.get(serviceInterfaceModule);
                    if (value.contains(serviceString)) continue;
                    value.add(serviceString);
                    this._serviceInterfaceLocations.put(serviceInterfaceModule, value);
                    continue;
                }
                value = new ArrayList<String>();
                value.add(serviceString);
                this._serviceInterfaceLocations.put(serviceInterfaceModule, value);
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn((Object)("The service interface of the service provider " + serviceString + " is not found."), (Throwable)e);
            }
        }
    }

    private void addServiceProvidersOfModule(Module providerModule) {
        Set<ModuleDescriptor.Provides> providedServices = providerModule.getDescriptor().provides();
        ModuleLayer providerLayer = providerModule.getLayer();
        for (ModuleDescriptor.Provides providedService : providedServices) {
            String service = providedService.service();
            Class<?> serviceInterface = this._serviceInterfaces.get(service);
            if (!this._providerLocations.containsKey(serviceInterface)) {
                ArrayList<ModuleLayer> value = new ArrayList<ModuleLayer>();
                value.add(providerLayer);
                this._providerLocations.put(serviceInterface, value);
                continue;
            }
            List<ModuleLayer> oldValue = this._providerLocations.get(serviceInterface);
            List<ModuleLayer> newValue = this._providerLocations.get(serviceInterface);
            newValue.add(providerLayer);
            this._providerLocations.replace(serviceInterface, oldValue, newValue);
        }
    }

    private List<ModuleLayer> getLocationsOfServiceProvider(Class<?> serviceInterface) {
        return this._providerLocations.getOrDefault(serviceInterface, List.of());
    }

    synchronized void removeServicesOfModules(Set<Module> modules) {
        for (Module module : modules) {
            this.removeServiceProvidersOfModule(module);
            this.removeServiceInterfacesOfModule(module);
        }
    }

    private synchronized void removeServiceInterfacesOfModule(Module providerModule) {
        if (this._serviceInterfaceLocations.containsKey(providerModule)) {
            for (String service : this._serviceInterfaceLocations.get(providerModule)) {
                this._providerLocations.remove(this._serviceInterfaces.get(service));
                this._serviceInterfaces.remove(service);
            }
            this._serviceInterfaceLocations.remove(providerModule);
        }
    }

    private synchronized void removeServiceProvidersOfModule(Module providerModule) {
        Set<ModuleDescriptor.Provides> providedServices = providerModule.getDescriptor().provides();
        ModuleLayer providerLayer = providerModule.getLayer();
        for (ModuleDescriptor.Provides providedService : providedServices) {
            String service = providedService.service();
            Class<?> serviceInterface = this._serviceInterfaces.get(service);
            List<ModuleLayer> value = null;
            if (serviceInterface != null) {
                value = this._providerLocations.get(serviceInterface);
            }
            if (value == null) {
                for (Map.Entry<Class<?>, List<ModuleLayer>> entry : this._providerLocations.entrySet()) {
                    if (!entry.getKey().toString().contains(service)) continue;
                    this._providerLocations.remove(entry.getKey());
                }
                continue;
            }
            if (value.size() > 1) {
                List<ModuleLayer> oldValue = this._providerLocations.get(serviceInterface);
                value.remove(providerLayer);
                this._providerLocations.replace(serviceInterface, oldValue, value);
                continue;
            }
            if (value.size() != 1) continue;
            this._providerLocations.remove(serviceInterface);
        }
    }

    final class LayerServicesListener
    implements ModuleLayerListener {
        LayerServicesListener() {
        }

        @Override
        public void layerAdded(Set<Module> modules) {
            ServiceLookupInfrastructure.this.addServicesOfModules(modules);
        }

        @Override
        public void layerRemoved(Set<Module> modules) {
            ServiceLookupInfrastructure.this.removeServicesOfModules(modules);
        }
    }
}

