/*
 * Decompiled with CFR 0.152.
 */
package de.renew.ptchannel.single;

import de.renew.expression.ConstantExpression;
import de.renew.expression.Expression;
import de.renew.expression.ListExpression;
import de.renew.expression.TupleExpression;
import de.renew.expression.TypeCheckingExpression;
import de.renew.expression.VariableExpression;
import de.renew.formalism.java.ParsedDeclarationNode;
import de.renew.formalism.java.SingleJavaNetCompiler;
import de.renew.net.Net;
import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.net.inscription.TransitionInscription;
import de.renew.net.inscription.transition.DownlinkInscription;
import de.renew.net.inscription.transition.UplinkInscription;
import de.renew.net.loading.NetLoader;
import de.renew.shadowcompiler.ShadowLookup;
import de.renew.simulatorontology.shadow.ShadowArc;
import de.renew.simulatorontology.shadow.ShadowDeclarationNode;
import de.renew.simulatorontology.shadow.ShadowInscription;
import de.renew.simulatorontology.shadow.ShadowNet;
import de.renew.simulatorontology.shadow.ShadowPlace;
import de.renew.simulatorontology.shadow.ShadowTransition;
import de.renew.simulatorontology.shadow.SyntaxException;
import de.renew.util.Value;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import java.util.stream.Collectors;

public class PTCTransitionCompiler
extends SingleJavaNetCompiler {
    public PTCTransitionCompiler(boolean allowDangerousArcs, boolean allowTimeInscriptions, boolean wantEarlyTokens) {
        super(allowDangerousArcs, allowTimeInscriptions, wantEarlyTokens);
    }

    public void compileArc(ShadowArc shadowArc, ParsedDeclarationNode declarationNode, ShadowLookup lookup) throws SyntaxException {
        this.declaration = declarationNode;
        this.lookup = lookup;
        shadowArc.setShadowArcType(4);
        super.compileArc(shadowArc);
    }

    public void compileArc(ShadowArc shadowArc, ShadowLookup lookup) throws SyntaxException {
        this.lookup = lookup;
        super.compileArc(shadowArc);
    }

    public String checkTransitionInscription(String inscription, boolean special, ShadowNet shadowNet) throws SyntaxException {
        this.makeDeclarationNode(shadowNet);
        Collection inscriptions = this.makeInscriptions(inscription, null, false);
        if (inscriptions.size() == 0) {
            throw new SyntaxException("Invalid inscription");
        }
        if (inscriptions.size() > 1) {
            throw new SyntaxException("Multiple inscriptions not supported");
        }
        for (TransitionInscription transitionInscription : inscriptions) {
            this.throwExceptionIfNotChannel(transitionInscription);
            if (!(transitionInscription instanceof DownlinkInscription)) continue;
            this.throwExceptionIfCalleeNotThis((DownlinkInscription)transitionInscription);
        }
        Object res = inscriptions.iterator().next();
        if (res instanceof UplinkInscription) {
            return "uplink";
        }
        if (res instanceof DownlinkInscription) {
            return "downlink";
        }
        throw new SyntaxException("Unsupported inscription");
    }

    public Collection<TransitionInscription> makeInscriptions(ShadowInscription inscription, ShadowLookup lookup, boolean create, ParsedDeclarationNode declarationNode, NetLoader loader) throws SyntaxException {
        String str = inscription.getInscription();
        Transition transition = lookup.get((ShadowTransition)inscription.getInscribable());
        this.declaration = declarationNode;
        this._loopbackNetLoader = loader;
        Collection inscriptions = this.makeInscriptions(str, transition, create);
        this.throwExceptionIfMultipleInscriptions(inscription, inscriptions);
        for (TransitionInscription transitionInscription : inscriptions) {
            this.throwExceptionIfNotChannel(transitionInscription);
            if (!(transitionInscription instanceof DownlinkInscription)) continue;
            this.throwExceptionIfCalleeNotThis((DownlinkInscription)transitionInscription);
        }
        return this.convertIntegerInscriptions(inscriptions);
    }

    private Collection<TransitionInscription> convertIntegerInscriptions(Collection<TransitionInscription> inscriptions) {
        return inscriptions.stream().map(inscription -> {
            if (inscription instanceof DownlinkInscription || inscription instanceof UplinkInscription) {
                return this.transformIntegerInscriptions((TransitionInscription)inscription);
            }
            return inscription;
        }).collect(Collectors.toCollection(ArrayList::new));
    }

    private TransitionInscription transformIntegerInscriptions(TransitionInscription inscription) {
        TupleExpression oldTuple = inscription instanceof DownlinkInscription ? (TupleExpression)((DownlinkInscription)inscription).getParameterExpression() : (TupleExpression)((UplinkInscription)inscription).getParams();
        Expression[] expressions = new Expression[oldTuple.getExpressions().length];
        for (int i = 0; i < oldTuple.getExpressions().length; ++i) {
            expressions[i] = oldTuple.getExpressions()[i] instanceof TypeCheckingExpression ? this.buildBlackTokenExpression((TypeCheckingExpression)oldTuple.getExpressions()[i]) : oldTuple.getExpressions()[i];
        }
        if (inscription instanceof DownlinkInscription) {
            DownlinkInscription oldDownlink = (DownlinkInscription)inscription;
            return new DownlinkInscription(oldDownlink.getName(), (Expression)new TupleExpression(expressions), oldDownlink.getCallee(), false, oldDownlink.getTransition());
        }
        UplinkInscription oldUplink = (UplinkInscription)inscription;
        return new UplinkInscription(oldUplink.getName(), (Expression)new TupleExpression(expressions));
    }

    private TypeCheckingExpression buildBlackTokenExpression(TypeCheckingExpression tce) {
        ConstantExpression constantExpression = (ConstantExpression)tce.getArgument();
        Value value = (Value)constantExpression.getConstant();
        int insc = value.intValue();
        TupleExpression[] emptyTuples = this.buildAggregatedTuples(insc);
        ListExpression list = new ListExpression((Expression[])emptyTuples, false);
        return new TypeCheckingExpression(list.getType(), (Expression)list);
    }

    private TupleExpression[] buildAggregatedTuples(int inscrValue) {
        TupleExpression[] expressions = new TupleExpression[inscrValue];
        for (int i = 0; i < inscrValue; ++i) {
            TupleExpression[] empty = new TupleExpression[]{};
            expressions[i] = new TupleExpression((Expression[])empty);
        }
        return expressions;
    }

    private void throwExceptionIfMultipleInscriptions(ShadowInscription inscription, Collection<TransitionInscription> inscriptions) throws SyntaxException {
        boolean inscriptionFound = false;
        for (Object elem : inscription.getInscribable().elements()) {
            if (!(elem instanceof ShadowInscription)) continue;
            if (inscriptionFound) {
                throw new SyntaxException("Multiple inscriptions not supported");
            }
            inscriptionFound = true;
        }
        if (inscriptions.size() > 1) {
            throw new SyntaxException("Multiple inscriptions not supported");
        }
    }

    private void throwExceptionIfNotChannel(TransitionInscription insc) throws SyntaxException {
        if (!(insc instanceof DownlinkInscription) && !(insc instanceof UplinkInscription)) {
            throw new SyntaxException("Only up- and downlinks are supported");
        }
    }

    private void throwExceptionIfCalleeNotThis(DownlinkInscription downlink) throws SyntaxException {
        if (!(downlink.getCallee() instanceof VariableExpression)) {
            throw new SyntaxException("Callee must be this.");
        }
        if (!((VariableExpression)downlink.getCallee()).getVariable().getName().equals("this")) {
            throw new SyntaxException("Callee must be this.");
        }
    }

    public void compilePlaceInscriptions(ShadowPlace shadowPlace, Place place) throws SyntaxException {
        super.compilePlaceInscriptions(shadowPlace, place);
    }

    public void compile(ShadowPlace shadowPlace, Net net, Serializable groupId) throws SyntaxException {
        super.compile(shadowPlace, net, groupId);
    }

    public void compile(ShadowTransition shadowTransition, Net net, Serializable groupId) throws SyntaxException {
        super.compile(shadowTransition, net, groupId);
    }

    public Collection<TransitionInscription> compileTransitionInscription(ShadowInscription inscription, ShadowLookup lookup) throws SyntaxException {
        this.lookup = lookup;
        return super.compileTransitionInscription(inscription);
    }

    public void compileTransitionInscriptions(ShadowTransition shadowTransition, Vector<TransitionInscription> parsedInscriptions, Vector<ShadowInscription> errorShadows) throws SyntaxException {
        super.compileTransitionInscriptions(shadowTransition, parsedInscriptions, errorShadows);
    }

    public ShadowDeclarationNode findDeclarationNode(ShadowNet shadowNet) throws SyntaxException {
        return super.findDeclarationNode(shadowNet);
    }
}

