/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.dock.station.span.Span;
import bibliothek.gui.dock.station.span.SpanCallback;
import bibliothek.gui.dock.station.span.SpanFactory;
import bibliothek.gui.dock.station.span.SpanMode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Timer;

public class BasicSpanFactory
implements SpanFactory {
    private int duration;
    private int minSpeed;
    private Timer timer;
    private Collection<BasicSpan> ticking = new HashSet<BasicSpan>();

    public BasicSpanFactory(int duration, int minSpeed) {
        this.setDuration(duration);
        this.setMinSpeed(minSpeed);
        this.timer = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasicSpanFactory.this.tick();
            }
        });
        this.timer.setRepeats(true);
        this.timer.setCoalesce(true);
        this.timer.setDelay(20);
        this.timer.setInitialDelay(0);
    }

    public void setDuration(int duration) {
        if (duration < 0) {
            throw new IllegalArgumentException("duration must be at least 0 milliseconds");
        }
        this.duration = duration;
    }

    public void setMinSpeed(int minSpeed) {
        this.minSpeed = minSpeed;
    }

    public int getMinSpeed() {
        return this.minSpeed;
    }

    public Span create(SpanCallback callback) {
        return new BasicSpan(callback);
    }

    private synchronized void start(BasicSpan span) {
        if (this.ticking.isEmpty()) {
            this.ticking.add(span);
            this.timer.start();
        } else {
            this.ticking.add(span);
        }
    }

    private synchronized void stop(BasicSpan span) {
        this.ticking.remove(span);
        if (this.ticking.isEmpty()) {
            this.timer.stop();
        }
    }

    private synchronized void tick() {
        long now = System.nanoTime();
        for (BasicSpan span : this.ticking.toArray(new BasicSpan[this.ticking.size()])) {
            span.tick(now);
        }
    }

    private class BasicSpan
    implements Span {
        private SpanCallback callback;
        private Map<SpanMode, Integer> sizes = new HashMap<SpanMode, Integer>(2);
        private SpanMode currentMode;
        private int sizeStart;
        private int sizeTarget;
        private int animationDuration = -1;
        private long animationStart = -1L;
        private int duration;

        public BasicSpan(SpanCallback callback) {
            this.callback = callback;
        }

        public void mutate(SpanMode mode) {
            this.sizeStart = this.getSize();
            this.sizeTarget = this.getSize(mode);
            this.duration = BasicSpanFactory.this.duration;
            if (this.sizeStart != this.sizeTarget) {
                if (BasicSpanFactory.this.minSpeed > 0) {
                    this.duration = Math.min(this.duration, 1000 * Math.abs(this.sizeStart - this.sizeTarget) / BasicSpanFactory.this.minSpeed);
                }
                this.animationDuration = 0;
                this.animationStart = -1L;
                BasicSpanFactory.this.start(this);
            }
        }

        public void set(SpanMode mode) {
            BasicSpanFactory.this.stop(this);
            this.animationDuration = -1;
            this.sizeTarget = this.getSize(mode);
            this.callback.resized();
        }

        private int getSize(SpanMode mode) {
            Integer size = this.sizes.get(mode);
            if (size == null) {
                return mode.getSize();
            }
            return size;
        }

        public void configureSize(SpanMode mode, int size) {
            this.sizes.put(mode, size);
            if (mode == this.currentMode) {
                this.set(mode);
            }
        }

        public void tick(long now) {
            if (this.animationStart == -1L) {
                this.animationStart = now;
            }
            this.animationDuration = (int)((now - this.animationStart) / 1000000L);
            if (this.animationDuration >= this.duration) {
                this.animationDuration = -1;
                BasicSpanFactory.this.stop(this);
            }
            this.callback.resized();
        }

        public int getSize() {
            if (this.animationDuration == -1) {
                return this.sizeTarget;
            }
            double ratio = (double)this.animationDuration / (double)this.duration;
            if (ratio > 1.0) {
                ratio = 1.0;
            }
            ratio = 2.0 * (1.0 - ratio) * ratio + ratio * ratio;
            return (int)((double)this.sizeStart * (1.0 - ratio) + (double)this.sizeTarget * ratio);
        }
    }
}

