/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen.window;

import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.station.screen.window.AbstractScreenDockWindow;
import bibliothek.gui.dock.station.screen.window.WindowConfiguration;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Workarounds;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JFrame;

public class ScreenDockFrame
extends AbstractScreenDockWindow {
    private JFrame frame = new JFrame();

    public ScreenDockFrame(ScreenDockStation station, WindowConfiguration configuration, boolean undecorated) {
        super(station, configuration);
        this.init(undecorated, configuration);
    }

    private void init(boolean undecorated, WindowConfiguration configuration) {
        if (undecorated) {
            this.frame.setUndecorated(true);
            this.frame.getRootPane().setWindowDecorationStyle(0);
        }
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ScreenDockFrame.this.fireWindowClosing();
            }
        });
        this.init(this.frame, this.frame.getContentPane(), configuration, undecorated);
        boolean translucency = false;
        if (configuration.isTransparent()) {
            translucency = Workarounds.getDefault().setTranslucent(this.frame);
        }
        if (!translucency && configuration.getShape() != null) {
            this.setShape(this.frame, configuration.getShape());
        }
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void destroy() {
        super.destroy();
        this.frame.dispose();
    }

    public void toFront() {
        this.frame.toFront();
    }

    protected void updateTitleText() {
        this.frame.setTitle(this.getTitleText());
    }

    public void setPreventFocusStealing(boolean prevent) {
        this.frame.setFocusableWindowState(!prevent);
    }

    protected void updateTitleIcon() {
        Icon icon = this.getTitleIcon();
        if (icon == null) {
            this.frame.setIconImage(null);
        } else {
            this.frame.setIconImage(DockUtilities.iconImage(icon));
        }
    }
}

