/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.accept.MultiDockAcceptance;
import bibliothek.gui.dock.control.relocator.DockRelocatorEvent;
import bibliothek.gui.dock.control.relocator.VetoableDockRelocatorAdapter;
import bibliothek.gui.dock.event.DockRegisterAdapter;

public class SingleParentRemover {
    private DockController controller;
    private DockRelocatorObserver dockRelocatorObserver = new DockRelocatorObserver();
    private DockRegisterObserver dockRegisterObserver = new DockRegisterObserver();
    private boolean onTest = false;

    public void install(DockController controller) {
        if (this.controller != null) {
            throw new IllegalStateException("a controller is already installed");
        }
        this.controller = controller;
        controller.getRelocator().addVetoableDockRelocatorListener(this.dockRelocatorObserver);
        controller.getRegister().addDockRegisterListener(this.dockRegisterObserver);
        this.testAll(controller);
    }

    public void uninstall(DockController controller) {
        if (this.controller != controller) {
            throw new IllegalArgumentException("controller is not installed");
        }
        controller.getRelocator().removeVetoableDockRelocatorListener(this.dockRelocatorObserver);
        controller.getRegister().removeDockRegisterListener(this.dockRegisterObserver);
        this.controller = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAll(DockController controller) {
        if (this.onTest) {
            return;
        }
        try {
            this.onTest = true;
            controller.getRegister().setStalled(true);
            int index = 0;
            while (index < controller.getRegister().getStationCount()) {
                if (this.test(controller.getRegister().getStation(index))) {
                    index = 0;
                    continue;
                }
                ++index;
            }
        }
        finally {
            controller.getRegister().setStalled(false);
            this.onTest = false;
        }
    }

    protected boolean shouldTest(DockStation station) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean test(DockStation station) {
        DockController controller = station.getController();
        if (controller != null) {
            controller.getRegister().setStalled(true);
            controller.getHierarchyLock().setConcurrent(true);
        }
        try {
            if (!this.shouldTest(station)) {
                boolean bl = false;
                return bl;
            }
            if (station.getDockableCount() > 1) {
                boolean bl = false;
                return bl;
            }
            Dockable transform = station.asDockable();
            if (transform == null) {
                boolean bl = false;
                return bl;
            }
            DockStation parent = transform.getDockParent();
            if (parent == null) {
                boolean bl = false;
                return bl;
            }
            if (parent.getController() == null) {
                boolean bl = false;
                return bl;
            }
            if (station.getDockableCount() == 0) {
                if (!parent.canDrag(transform)) {
                    boolean bl = false;
                    return bl;
                }
                parent.drag(transform);
                boolean bl = true;
                return bl;
            }
            Dockable dockable = station.getDockable(0);
            if (!station.canDrag(dockable)) {
                boolean bl = false;
                return bl;
            }
            if (!parent.accept(dockable) || !dockable.accept(parent)) {
                boolean bl = false;
                return bl;
            }
            if (!parent.canReplace(transform, dockable)) {
                boolean bl = false;
                return bl;
            }
            MultiDockAcceptance acceptance = station.getController().getAcceptance();
            if (acceptance != null && !acceptance.accept(parent, dockable)) {
                boolean bl = false;
                return bl;
            }
            station.drag(dockable);
            parent.replace(transform.asDockStation(), dockable);
            boolean bl = true;
            return bl;
        }
        finally {
            if (controller != null) {
                controller.getHierarchyLock().setConcurrent(false);
                controller.getRegister().setStalled(false);
            }
        }
    }

    private class DockRelocatorObserver
    extends VetoableDockRelocatorAdapter {
        private DockRelocatorObserver() {
        }

        public void dropped(DockRelocatorEvent event) {
            SingleParentRemover.this.testAll(SingleParentRemover.this.controller);
        }
    }

    private class DockRegisterObserver
    extends DockRegisterAdapter {
        private DockRegisterObserver() {
        }

        public void dockableCycledRegister(DockController controller, Dockable dockable) {
            SingleParentRemover.this.testAll(controller);
        }

        public void dockableRegistered(DockController controller, Dockable dockable) {
            if (!controller.getRelocator().isOnPut()) {
                SingleParentRemover.this.testAll(controller);
            }
        }

        public void dockableUnregistered(DockController controller, Dockable dockable) {
            if (!controller.getRelocator().isOnPut()) {
                SingleParentRemover.this.testAll(controller);
            }
        }

        public void dockStationRegistered(final DockController controller, DockStation station) {
            controller.getHierarchyLock().onRelease(new Runnable(){

                public void run() {
                    SingleParentRemover.this.testAll(controller);
                }
            });
        }
    }
}

