/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.component;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.component.DockComponentConfiguration;
import bibliothek.gui.dock.component.DockComponentConfigurationEvent;
import bibliothek.gui.dock.component.DockComponentRoot;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.HashSet;
import java.util.Set;

public abstract class DockComponentRootHandler {
    private DockComponentRoot root;
    private DockComponentConfiguration configuration;
    private DockController controller;
    private Listener listener = new Listener();
    private Set<Component> handledComponents = new HashSet<Component>();

    public DockComponentRootHandler(DockComponentRoot root) {
        if (root == null) {
            throw new IllegalArgumentException("root must not be null");
        }
        this.root = root;
    }

    public void setConfiguration(DockComponentConfiguration configuration) {
        if (this.configuration != configuration) {
            DockComponentConfigurationEvent event;
            if (this.configuration != null) {
                for (Component component : this.handledComponents) {
                    event = new DockComponentConfigurationEvent(this.root, component);
                    this.configuration.unconfigure(event);
                }
            }
            this.configuration = configuration;
            if (this.configuration != null) {
                for (Component component : this.handledComponents) {
                    event = new DockComponentConfigurationEvent(this.root, component);
                    this.configuration.configure(event);
                }
            }
        }
    }

    public DockComponentConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setController(DockController controller) {
        if (this.controller != controller) {
            if (this.controller != null) {
                this.controller.getDockComponentManager().unregister(this.root);
            }
            this.controller = controller;
            if (this.controller != null) {
                this.controller.getDockComponentManager().register(this.root);
            }
        }
    }

    public void addRoot(Component component) {
        this.add(component);
    }

    public void removeRoot(Component component) {
        this.remove(component);
    }

    private void add(Component component) {
        TraverseResult traversing = this.shouldTraverse(component);
        if (traversing == TraverseResult.EXCLUDE_CHILDREN || traversing == TraverseResult.INCLUDE_CHILDREN) {
            DockComponentConfigurationEvent event = new DockComponentConfigurationEvent(this.root, component);
            if (this.configuration != null) {
                this.configuration.configure(event);
            }
            this.handledComponents.add(component);
        }
        if (traversing == TraverseResult.INCLUDE_CHILDREN && component instanceof Container) {
            Container container = (Container)component;
            container.addContainerListener(this.listener);
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                this.add(container.getComponent(i));
            }
        }
    }

    private void remove(Component component) {
        if (this.handledComponents.remove(component)) {
            DockComponentConfigurationEvent event = new DockComponentConfigurationEvent(this.root, component);
            if (this.configuration != null) {
                this.configuration.unconfigure(event);
            }
            if (component instanceof Container) {
                Container container = (Container)component;
                container.removeContainerListener(this.listener);
                int n = container.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    this.remove(container.getComponent(i));
                }
            }
        }
    }

    protected abstract TraverseResult shouldTraverse(Component var1);

    private class Listener
    implements ContainerListener {
        private Listener() {
        }

        public void componentAdded(ContainerEvent e) {
            DockComponentRootHandler.this.add(e.getChild());
        }

        public void componentRemoved(ContainerEvent e) {
            DockComponentRootHandler.this.remove(e.getChild());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum TraverseResult {
        INCLUDE_CHILDREN,
        EXCLUDE_CHILDREN,
        EXCLUDE;

    }
}

