/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.models;

import de.renew.navigator.models.DirectoryType;
import de.renew.navigator.models.TreeElement;
import java.util.List;

public final class Directory
extends TreeElement {
    private boolean _opened;
    private DirectoryType _type;

    public List<TreeElement> getChildren() {
        return this._elements;
    }

    public void setChildren(List<TreeElement> children) {
        this._elements = children;
        this.setChanged();
    }

    public boolean isOpened() {
        return this._opened;
    }

    public void setOpened(boolean opened) {
        this._opened = opened;
        if (opened) {
            if (this.getParent() instanceof Directory) {
                ((Directory)this.getParent()).setOpened(true);
            }
        } else {
            for (TreeElement child : this._elements) {
                if (!(child instanceof Directory)) continue;
                ((Directory)child).setOpened(false);
            }
        }
        this.setChanged();
    }

    public DirectoryType getType() {
        return this._type;
    }

    public void setType(DirectoryType type) {
        this._type = type;
    }

    @Override
    public void setExcluded(boolean excluded) {
        super.setExcluded(excluded);
        if (excluded) {
            for (TreeElement child : this._elements) {
                child.setExcluded(true);
            }
            return;
        }
        if (this.getParent() instanceof TreeElement) {
            ((TreeElement)this.getParent()).setExcluded(false);
        }
    }

    @Override
    public String toString() {
        return super.toString() + ", elements=" + this._elements.size();
    }

    @Override
    public void expandAll() {
        this.setOpened(true);
        for (TreeElement child : this._elements) {
            if (!(child instanceof Directory)) continue;
            Directory directory = (Directory)child;
            directory.expandAll();
        }
    }
}

