/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.models;

import java.util.Observable;

public class BackgroundTask
extends Observable {
    private String _name;
    private float _current;
    private Runnable _cancelAction;

    public BackgroundTask(String name) {
        this._name = name;
        this._current = -1.0f;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
        this.setChanged();
    }

    public float getCurrent() {
        return this._current;
    }

    public void setCurrent(float current) {
        this._current = current;
        this.setChanged();
    }

    public boolean isIndeterminate() {
        return this._current == -1.0f;
    }

    public boolean isCancelable() {
        return this._cancelAction != null;
    }

    public Runnable getCancelAction() {
        return this._cancelAction;
    }

    public void setCancelAction(Runnable cancelAction) {
        this._cancelAction = cancelAction;
        this.setChanged();
    }

    public void cancel() {
        if (this._cancelAction != null) {
            this._cancelAction.run();
        }
    }

    public void increaseCurrent(float amount) {
        this._current += amount;
        this.setChanged();
    }
}

