/*
 * Decompiled with CFR 0.152.
 */
package de.renew.ccpn.net;

import de.renew.net.NetInstance;
import de.renew.net.Place;
import de.renew.net.PlaceInstance;
import de.renew.net.TimeSet;
import de.renew.net.event.PlaceEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CurryPlaceInstance
extends PlaceInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<CurryToken, Integer> _marking = new HashMap<CurryToken, Integer>();

    CurryPlaceInstance(NetInstance netInstance, Place place) {
        super(netInstance, place);
    }

    public void resetMarking() {
        this._lock.lock();
        try {
            this._marking.clear();
        }
        finally {
            this._lock.unlock();
        }
    }

    public void addToken(String str, int count) {
        this._lock.lock();
        try {
            this._marking.put(new CurryToken(str), count);
        }
        finally {
            this._lock.unlock();
        }
    }

    public void notifyListeners() {
        PlaceEvent te = new PlaceEvent(this._netInstance.getInstance(this._place));
        this._listeners.markingChanged(te);
        this._place.getListenerSet().markingChanged(te);
    }

    public Set<Object> getDistinctTokens() {
        this._lock.lock();
        try {
            Set<Object> set = this._marking.keySet();
            return set;
        }
        finally {
            this._lock.unlock();
        }
    }

    public Set<Object> getDistinctTestableTokens() {
        return this.getDistinctTokens();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfTokens() {
        this._lock.lock();
        try {
            int n = 0;
            for (int i : this._marking.values()) {
                n += i;
            }
            int n2 = n;
            return n2;
        }
        finally {
            this._lock.unlock();
        }
    }

    public int getNumberOfTestedTokens() {
        return 0;
    }

    public boolean isEmpty() {
        this._lock.lock();
        try {
            boolean bl = this._marking.isEmpty();
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    public int getTokenCount(Object token) {
        this._lock.lock();
        try {
            int n = this._marking.get(token);
            return n;
        }
        finally {
            this._lock.unlock();
        }
    }

    public TimeSet getFreeTimeSet(Object token) {
        this._lock.lock();
        try {
            TimeSet timeSet = TimeSet.make((double)0.0, (int)this._marking.get(token));
            return timeSet;
        }
        finally {
            this._lock.unlock();
        }
    }

    public boolean containsTestedToken(Object token) {
        return false;
    }

    private static class CurryToken
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final String _str;

        CurryToken(String str) {
            this._str = str;
        }

        public String toString() {
            return this._str;
        }
    }
}

