/*
 * Decompiled with CFR 0.152.
 */
package de.renew.ccpn.engine.simulator;

import de.renew.ccpn.engine.simulator.CCPNProcess;
import de.renew.simulatorontology.simulation.Simulator;
import de.renew.simulatorontology.simulation.StepIdentifier;
import org.apache.log4j.Logger;

public class CurrySimulator
implements Simulator {
    public static final Logger LOGGER = Logger.getLogger(CurrySimulator.class);
    private CCPNProcess _process;
    private static final long[] EMPTY_RUN_IDS = new long[0];

    public CurrySimulator(boolean wantEventQueueDelay) {
        this();
    }

    public CurrySimulator() {
    }

    public boolean isActive() {
        return true;
    }

    private synchronized boolean processStopped() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(CurrySimulator.class.getSimpleName() + ": determining if CCPN process is stopped: " + String.valueOf(this._process)));
        }
        return this._process == null || this._process._stopped;
    }

    public synchronized void startRun() {
        if (!this.processStopped()) {
            this._process._continuousUpdate = true;
            this._process.run();
        }
    }

    public void setProcess(CCPNProcess process) {
        this._process = process;
    }

    public synchronized void stopRun() {
        if (!this.processStopped()) {
            this._process._continuousUpdate = false;
            this._process.stop();
        }
    }

    public synchronized void terminateRun() {
        if (this._process != null) {
            this._process.terminate();
            this._process = null;
        }
    }

    public synchronized int step() {
        if (this.processStopped()) {
            return 0;
        }
        if (this._process._continuousUpdate) {
            this.stopRun();
        } else {
            this._process.step();
        }
        return 1;
    }

    public void refresh() {
    }

    public boolean isSequential() {
        return false;
    }

    public StepIdentifier nextStepIdentifier() {
        return null;
    }

    public StepIdentifier currentStepIdentifier() {
        return null;
    }

    public long[] collectSimulationRunIds() {
        return EMPTY_RUN_IDS;
    }
}

