/*
 * Decompiled with CFR 0.152.
 */
package de.renew.ccpn;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.util.CommandMenuItem;
import de.renew.application.SimulatorPlugin;
import de.renew.ccpn.commands.CurryReachabilityGraphCommand;
import de.renew.ccpn.engine.simulator.CCPNSimulation;
import de.renew.ccpn.engine.simulator.CurrySimulator;
import de.renew.ccpn.formalism.java.CurryNetCompiler;
import de.renew.draw.ui.api.MenuApi;
import de.renew.draw.ui.ontology.AbstractCommand;
import de.renew.formalism.FormalismChangeListener;
import de.renew.formalism.FormalismPlugin;
import de.renew.gui.CPNSimulation;
import de.renew.gui.ModeReplacement;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginProperties;
import de.renew.shadowcompiler.ShadowCompilerFactory;
import java.net.URL;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class CCPNPlugin
extends PluginAdapter
implements FormalismChangeListener {
    public static final Logger LOGGER = Logger.getLogger(CCPNPlugin.class);
    public static final String CCPN_COMPILER = "Curry Net Compiler";
    public static final String DEFAULT_SIMULATOR_CLASS = CurrySimulator.class.getName();
    public static final String CCPN_LOCATION_PROPERTY = "de.renew.formalism.ccpn.ccpnbin";
    private static String _ccpnLocation;
    private final CommandMenuItem _menuItem = new CommandMenuItem((AbstractCommand)new CurryReachabilityGraphCommand());
    private String _previousSimulatorClass;

    public CCPNPlugin(URL location) throws PluginException {
        super(location);
    }

    public CCPNPlugin(PluginProperties props) {
        super(props);
    }

    public void init() {
        _ccpnLocation = SimulatorPlugin.getCurrent().getProperties().getProperty(CCPN_LOCATION_PROPERTY);
        if (_ccpnLocation == null) {
            throw new RuntimeException("The ccpn binary location must be given by: -Dde.renew.formalism.ccpn.ccpnbin=path/to/ccpn");
        }
        if (DrawPlugin.getCurrent() != null) {
            MenuApi.registerMenu((String)"Tools", (JMenuItem)this._menuItem, (String)"de.renew.rnrg");
        }
        FormalismPlugin fp = FormalismPlugin.getCurrent();
        fp.addFormalismChangeListener((FormalismChangeListener)this);
        fp.addCompilerFactory(CCPN_COMPILER, (ShadowCompilerFactory)new CurryNetCompiler());
        super.init();
    }

    public boolean cleanup() {
        if (DrawPlugin.getCurrent() != null) {
            MenuApi.unregisterMenu((JMenuItem)this._menuItem);
        }
        FormalismPlugin fp = FormalismPlugin.getCurrent();
        fp.removeFormalismChangeListener((FormalismChangeListener)this);
        fp.removeCompilerFactory(CCPN_COMPILER);
        return true;
    }

    public void formalismChanged(String currentCompiler, Object source, int action) {
        if (action == 2) {
            PluginProperties props = SimulatorPlugin.getCurrent().getProperties();
            String currentSimulator = props.getProperty("de.renew.simulatorClass");
            ModeReplacement mr = ModeReplacement.getInstance();
            boolean ccpnCompilerChosen = CCPN_COMPILER.equals(currentCompiler);
            boolean ccpnSimulatorSet = DEFAULT_SIMULATOR_CLASS.equals(currentSimulator);
            if (ccpnCompilerChosen && !ccpnSimulatorSet) {
                this._previousSimulatorClass = currentSimulator;
                props.setProperty("de.renew.simulatorClass", DEFAULT_SIMULATOR_CLASS);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(CCPNPlugin.class.getSimpleName() + ": Set simulator class property to " + DEFAULT_SIMULATOR_CLASS + ", because formalism Curry Net Compiler was chosen."));
                }
                mr.getSimulation().dispose();
                mr.setSimulation((CPNSimulation)new CCPNSimulation(mr.getDrawingLoader()));
            } else if (!ccpnCompilerChosen && ccpnSimulatorSet) {
                mr.getSimulation().dispose();
                mr.setSimulation(null);
                if (this._previousSimulatorClass == null) {
                    props.remove((Object)"de.renew.simulatorClass");
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)(CCPNPlugin.class.getSimpleName() + ": Remove simulator class property set to " + DEFAULT_SIMULATOR_CLASS + ", because Curry Net Compiler is no longer the chosen formalism."));
                    }
                } else {
                    props.setProperty("de.renew.simulatorClass", this._previousSimulatorClass);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)(CCPNPlugin.class.getSimpleName() + ": Set simulator class property to old value " + this._previousSimulatorClass + " and remove the distribute extension, because Curry Net Compiler is no longer the chosen formalism."));
                    }
                }
            }
        }
    }

    public static String getCCPNLocation() {
        return _ccpnLocation;
    }
}

