/*
 * Decompiled with CFR 0.152.
 */
package de.renew.io.importFormats;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.gui.pnml.PNMLFormat;
import de.renew.io.FileFilterCreator;
import de.renew.ioontology.FileFilter;
import de.renew.ioontology.importing.ImportFormatAbstract;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PNMLImportFormat
extends ImportFormatAbstract<Drawing> {
    public PNMLImportFormat() {
        super("PNML", (FileFilter)FileFilterCreator.createPNMLFileFilter());
    }

    public List<Drawing> importFiles(URL[] files) throws Exception {
        ArrayList<Drawing> list = new ArrayList<Drawing>();
        if (files != null) {
            for (URL file : files) {
                list.addAll(this.importFile(file));
            }
        }
        return list;
    }

    protected List<Drawing> importFile(URL file) throws Exception {
        if (file == null) {
            return Collections.emptyList();
        }
        InputStream stream = file.openStream();
        PNMLFormat format = new PNMLFormat();
        List<Drawing> result = format.parse(stream);
        stream.close();
        return result;
    }

    public List<Drawing> importFile(String src) throws Exception {
        if (src == null || src == "") {
            return Collections.emptyList();
        }
        PNMLFormat format = new PNMLFormat();
        return format.parse(new ByteArrayInputStream(src.getBytes()));
    }
}

