/*
 * Decompiled with CFR 0.152.
 */
package de.renew.io.exportFormats;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.storables.ontology.exporting.AbstractDrawingExportFormat;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNDrawing;
import de.renew.gui.ModeReplacement;
import de.renew.gui.PlaceFigure;
import de.renew.gui.ShadowHolder;
import de.renew.gui.TransitionFigure;
import de.renew.io.FileFilterCreator;
import de.renew.ioontology.FileFilter;
import de.renew.simulatorontology.shadow.ShadowArc;
import de.renew.simulatorontology.shadow.ShadowInscription;
import de.renew.simulatorontology.shadow.ShadowPlace;
import de.renew.simulatorontology.shadow.ShadowTransition;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class WoflanExportFormat
extends AbstractDrawingExportFormat {
    public WoflanExportFormat() {
        super("Woflan", (FileFilter)FileFilterCreator.createWoflanFileFilter());
    }

    public boolean canExportNto1() {
        return false;
    }

    public File export(Drawing drawing, File path) throws Exception {
        File result = null;
        if (drawing != null && path != null) {
            result = path;
            ModeReplacement.getInstance().getSimulation().buildAllShadows();
            PrintWriter p = new PrintWriter(new FileOutputStream(result));
            int cnt = 0;
            FigureEnumeration placeenumeration = drawing.figures();
            while (placeenumeration.hasMoreElements()) {
                Figure figure = placeenumeration.nextFigure();
                if (!(figure instanceof PlaceFigure)) continue;
                ShadowPlace place = (ShadowPlace)((ShadowHolder)figure).getShadow();
                Object name = place.getName();
                if (name == null) {
                    name = "P" + ++cnt;
                    place.setName((String)name);
                }
                p.println("place " + (String)name + ";");
            }
            cnt = 0;
            FigureEnumeration transenumeration = drawing.figures();
            while (transenumeration.hasMoreElements()) {
                Figure figure = transenumeration.nextFigure();
                if (!(figure instanceof TransitionFigure)) continue;
                ShadowTransition trans = (ShadowTransition)((ShadowHolder)figure).getShadow();
                Object name = trans.getName();
                if (name == null) {
                    name = "T" + ++cnt;
                    trans.setName((String)name);
                }
                ArrayList<String> inarcs = new ArrayList<String>();
                ArrayList<String> outarcs = new ArrayList<String>();
                for (Object elem : trans.elements()) {
                    ShadowInscription shadowInscription;
                    if (!(elem instanceof ShadowInscription) || !(shadowInscription = (ShadowInscription)elem).getInscription().startsWith(":new(")) continue;
                    inarcs.add("pinit");
                }
                FigureEnumeration arcenumeration = drawing.figures();
                while (arcenumeration.hasMoreElements()) {
                    ArcConnection ac;
                    ShadowArc arc;
                    figure = arcenumeration.nextFigure();
                    if (!(figure instanceof ArcConnection) || (arc = (ShadowArc)(ac = (ArcConnection)figure).getShadow()).getTransition() != trans) continue;
                    String placename = arc.getPlace().getName();
                    if (arc.getShadowArcType() == 2 || arc.getShadowArcType() == 0) {
                        inarcs.add(placename);
                        outarcs.add(placename);
                        continue;
                    }
                    if (arc.getShadowArcType() != 1) continue;
                    if (arc.isPlaceToTransition()) {
                        inarcs.add(placename);
                        continue;
                    }
                    outarcs.add(placename);
                }
                p.println("trans " + (String)name + this.placeVector(inarcs, " in") + this.placeVector(outarcs, " out") + ";");
            }
            p.close();
        }
        assert (result != null) : "Failure in WoflanExportFormat: result == null";
        return result;
    }

    public File export(Drawing[] drawings, File path) throws Exception {
        File result = null;
        assert (result != null) : "Failure in WoflanExportFormat: result == null";
        return result;
    }

    private String placeVector(List<String> places, String title) {
        StringBuilder output = new StringBuilder();
        if (!places.isEmpty()) {
            output.append(title);
            for (int i = places.size() - 1; i >= 0; --i) {
                output.append(" ").append(places.get(i));
            }
        }
        return output.toString();
    }

    public boolean canExportDrawing(Drawing drawing) {
        return drawing instanceof CPNDrawing;
    }
}

