/*
 * Decompiled with CFR 0.152.
 */
package de.renew.io.exportFormats;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.exporting.AbstractDrawingExportFormat;
import de.renew.gui.CPNDrawing;
import de.renew.gui.pnml.PNMLFormat;
import de.renew.io.FileFilterCreator;
import de.renew.ioontology.FileFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public abstract class PNMLExportFormat
extends AbstractDrawingExportFormat {
    public static final String ptNetType = "http://www.pnml.org/version-2009/grammar/ptnet";
    public static final String refNetType = "RefNet";
    private final String _type;
    private final boolean _toolInsc;

    public PNMLExportFormat(String name, String type, boolean toolInsc) {
        super("PNML-" + name, (FileFilter)FileFilterCreator.createPNMLFileFilter());
        this._type = type;
        this._toolInsc = toolInsc;
    }

    public boolean canExportNto1() {
        return true;
    }

    public File export(Drawing drawing, File path) throws Exception {
        if (drawing != null && path != null) {
            FileOutputStream stream = new FileOutputStream(path);
            PNMLFormat format = new PNMLFormat(this._type, this._toolInsc);
            format.write((OutputStream)stream, (CPNDrawing)drawing);
            return path;
        }
        return null;
    }

    public File export(Drawing[] drawings, File path) throws Exception {
        if (drawings != null && path != null) {
            FileOutputStream stream = new FileOutputStream(path);
            PNMLFormat format = new PNMLFormat(this._type, this._toolInsc);
            CPNDrawing[] cpn = new CPNDrawing[drawings.length];
            for (int pos = 0; pos < cpn.length; ++pos) {
                cpn[pos] = (CPNDrawing)drawings[pos];
            }
            format.write((OutputStream)stream, cpn);
            return path;
        }
        return null;
    }

    public boolean canExportDrawing(Drawing drawing) {
        return drawing instanceof CPNDrawing;
    }
}

