/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.nin;

import de.renew.gui.nin.FormattedNumberTextField;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class CustomCompositionPanel {
    public static Map<String, Map<String, FormattedNumberTextField>> showConfirmDialog(JPanel parent, String title, Set<String> channelNames, int size) {
        HashMap<String, Map<String, FormattedNumberTextField>> compSelectionMap = new HashMap<String, Map<String, FormattedNumberTextField>>();
        JPanel container = new JPanel();
        container.setLayout(new GridLayout());
        ArrayList<String> channelList = new ArrayList<String>(channelNames);
        for (int i = 0; i < size; ++i) {
            JPanel channelContainer = new JPanel();
            channelContainer.setLayout(new BoxLayout(channelContainer, 1));
            String netName = "net" + i;
            channelContainer.setBorder(new TitledBorder(netName));
            HashMap<String, FormattedNumberTextField> channelNumberMap = new HashMap<String, FormattedNumberTextField>();
            for (String channel : channelList) {
                JPanel elementContainer = new JPanel();
                elementContainer.setLayout(new GridLayout());
                DefaultListModel<String> model = new DefaultListModel<String>();
                JList list = new JList(model);
                model.addElement(channel);
                elementContainer.add(list);
                elementContainer.add(CustomCompositionPanel.buildCountPanel(channel, channelNumberMap));
                channelContainer.add(elementContainer);
            }
            compSelectionMap.put(netName, channelNumberMap);
            container.add(channelContainer);
        }
        JScrollPane scrollPane = new JScrollPane(container);
        int height = channelNames.size() < 4 ? 80 * channelNames.size() : 200;
        scrollPane.setPreferredSize(new Dimension(600, height));
        JOptionPane.showConfirmDialog(parent, scrollPane, title, -1);
        return compSelectionMap;
    }

    private static JPanel buildCountPanel(String channel, Map<String, FormattedNumberTextField> channelNumberMap) {
        JPanel countpanel = new JPanel();
        FormattedNumberTextField numberfield = new FormattedNumberTextField(0);
        countpanel.setLayout(new GridLayout());
        JButton plusbutton = new JButton("+");
        JButton minusbutton = new JButton("-");
        CustomCompositionPanel.addPlusMinusActions(plusbutton, minusbutton, numberfield);
        countpanel.add(plusbutton);
        countpanel.add(numberfield);
        countpanel.add(minusbutton);
        channelNumberMap.put(channel, numberfield);
        return countpanel;
    }

    private static void addPlusMinusActions(JButton plusbutton, JButton minusbutton, FormattedNumberTextField numberfield) {
        plusbutton.addActionListener(e -> {
            int instanceCount = (Integer)numberfield.getValue();
            if (++instanceCount >= 0 && instanceCount < Integer.MAX_VALUE) {
                numberfield.setValue(instanceCount);
            }
        });
        minusbutton.addActionListener(e -> {
            int instanceCount = (Integer)numberfield.getValue();
            if (--instanceCount >= 0 && instanceCount < Integer.MAX_VALUE) {
                numberfield.setValue(instanceCount);
            }
        });
    }
}

