/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.FigureChangeAdapter;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.MergedFigureEnumerator;
import de.renew.draw.storables.api.StorableApi;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureChangeEvent;
import de.renew.draw.storables.ontology.FigureChangeListener;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.storables.ontology.Storable;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.gui.PlaceFigure;
import de.renew.simulatorontology.shadow.ShadowNet;
import de.renew.simulatorontology.shadow.ShadowNetElement;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class VirtualPlaceFigure
extends PlaceFigure {
    private static final long serialVersionUID = -7877776241236946511L;
    private final int virtualPlaceFigureSerializedDataVersion = 1;
    private PlaceFigure place = null;

    public VirtualPlaceFigure() {
    }

    public VirtualPlaceFigure(PlaceFigure place) {
        this.setPlace(place);
    }

    private void setPlace(PlaceFigure place) {
        this.place = (PlaceFigure)place.getSemanticFigure();
        this.adapt();
        final FigureChangeEvent removeEvent = StorableApi.createFigureChangeEvent((Figure)this, null);
        place.addFigureChangeListener((FigureChangeListener)new FigureChangeAdapter(){

            public void figureChanged(FigureChangeEvent e) {
                VirtualPlaceFigure.this.adapt();
            }

            public void figureRemoved(FigureChangeEvent e) {
                if (VirtualPlaceFigure.this.listener() != null) {
                    VirtualPlaceFigure.this.listener().figureRequestRemove(removeEvent);
                }
            }
        });
    }

    @Override
    public PlaceFigure getSemanticFigure() {
        return (PlaceFigure)this.place.getSemanticFigure();
    }

    private void adapt() {
        super.setAttribute("FillColor", (Object)this.place.getFillColor());
        super.setAttribute("FrameColor", (Object)this.place.getFrameColor());
    }

    public void drawFrame(Graphics g) {
        super.drawFrame(g);
        Rectangle r = this.displayBox();
        Ellipse2D.Double s = new Ellipse2D.Double(r.x + 2, r.y + 2, r.width - 4, r.height - 4);
        ((Graphics2D)g).draw(s);
    }

    @Override
    public ShadowNetElement buildShadow(ShadowNet net) {
        return null;
    }

    @Override
    public ShadowNetElement getShadow() {
        return this.place.getShadow();
    }

    public void setAttribute(String attr, Object value) {
        if ("FillColor".equals(attr) || "FrameColor".equals(attr)) {
            this.place.setAttribute(attr, value);
        } else {
            super.setAttribute(attr, value);
        }
    }

    public boolean inspect(DrawingView view, boolean alternate) {
        if (alternate) {
            return super.inspect(view, true);
        }
        view.clearSelection();
        view.addToSelection((Figure)this.place);
        return true;
    }

    @Override
    public FigureEnumeration getFiguresWithDependencies() {
        FigureEnumeration superDep = super.getFiguresWithDependencies();
        Vector<PlaceFigure> myDep = new Vector<PlaceFigure>(1);
        myDep.addElement(this.place);
        return new MergedFigureEnumerator(superDep, (FigureEnumeration)new FigureEnumerator(myDep));
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable((Storable)this.place);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.setPlace((PlaceFigure)dr.readStorable());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setPlace(this.place);
    }
}

