/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.standard.CompositeFigure;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureChangeEvent;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.draw.ui.ontology.FigureHandle;
import de.renew.gui.ClickHandle;
import de.renew.gui.TokenHandle;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public abstract class SimpleCompositeFigure
extends CompositeFigure {
    protected Rectangle fDisplayBox = new Rectangle(0, 0, 0, 0);
    private transient Vector<FigureHandle> fHandles = null;
    protected final Vector<ClickHandle> fClickHandles = new Vector();

    public void addClickHandle(ClickHandle handle) {
        this.fClickHandles.addElement(handle);
        this.fHandles = null;
        this.handlesChanged();
    }

    protected void basicMoveBy(int x, int y) {
        this.fDisplayBox.translate(x, y);
        super.basicMoveBy(x, y);
    }

    public void moveBy(int x, int y) {
        this.willChange();
        this.basicMoveBy(x, y);
        this.changed();
    }

    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    public void basicDisplayBox(Point origin, Point corner) {
        this.fDisplayBox = new Rectangle(origin);
        this.fDisplayBox.add(corner);
        this.layout();
    }

    protected Vector<FigureHandle> basicHandles() {
        return new Vector<FigureHandle>();
    }

    public Vector<FigureHandle> handles() {
        if (this.fHandles == null) {
            this.fHandles = this.basicHandles();
            FigureEnumeration k = this.figures();
            while (k.hasMoreElements()) {
                Figure figure = k.nextFigure();
                Enumeration kk = figure.handles().elements();
                while (kk.hasMoreElements()) {
                    FigureHandle handle = (FigureHandle)kk.nextElement();
                    if (!(handle instanceof TokenHandle)) continue;
                    this.fHandles.addElement(handle);
                }
            }
            Enumeration<ClickHandle> clickHandles = this.fClickHandles.elements();
            while (clickHandles.hasMoreElements()) {
                this.fHandles.addElement(clickHandles.nextElement());
            }
        }
        return this.fHandles;
    }

    protected void figureSetChanged() {
        super.figureSetChanged();
        this.fHandles = null;
        this.handlesChanged();
    }

    protected void layout() {
        for (int i = 0; i < this.fClickHandles.size(); ++i) {
            ClickHandle handle = this.fClickHandles.elementAt(i);
            Dimension size = handle.owner().size();
            handle.setBox(new Rectangle(0, 0, size.width, size.height));
        }
    }

    protected abstract boolean needsLayout();

    public void update(FigureChangeEvent e) {
        if (this.needsLayout()) {
            this.willChange();
            this.layout();
            this.changed();
        }
    }

    public void figureChanged(FigureChangeEvent e) {
        this.update(e);
    }

    public void figureHandlesChanged(FigureChangeEvent e) {
        this.fHandles = null;
        this.handlesChanged();
    }

    public void figureRemoved(FigureChangeEvent e) {
        this.update(e);
    }

    public boolean inspect(DrawingView view, boolean alternate) {
        Point click = view.lastClick();
        Figure inside = this.findFigureInside(click.x, click.y);
        if (inside != null && inside.inspect(view, alternate)) {
            return true;
        }
        if (alternate) {
            return false;
        }
        return super.inspect(view, false);
    }

    public void setAttribute(String name, Object value) {
        FigureEnumeration figenumeration = this.figures();
        while (figenumeration.hasMoreElements()) {
            ((Figure)figenumeration.nextElement()).setAttribute(name, value);
        }
    }

    public Object getAttribute(String name) {
        FigureEnumeration figenumeration = this.figures();
        if (figenumeration.hasMoreElements()) {
            return ((Figure)figenumeration.nextElement()).getAttribute(name);
        }
        return null;
    }

    public void write(StorableOutput dw) {
        throw new RuntimeException("SimpleCompositeFigure is not storable!");
    }
}

