/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.application.SimulatorPlugin;
import de.renew.formalism.FormalismChangeListener;
import de.renew.formalism.FormalismPlugin;
import de.renew.gui.CPNApplication;
import de.renew.gui.CPNDrawingLoader;
import de.renew.gui.CPNSimulation;
import de.renew.gui.GuiFinder;
import de.renew.gui.GuiPlugin;
import de.renew.shadowcompiler.ShadowCompilerFactory;
import de.renew.shadowcompiler.ShadowNetSystemCompiler;
import de.renew.simulator.api.FinderRegistration;
import de.renew.simulatorontology.loading.Finder;
import de.renew.simulatorontology.shadow.ShadowNetSystem;
import java.awt.EventQueue;
import org.apache.log4j.Logger;

public class ModeReplacement
implements FormalismChangeListener {
    private static final Logger logger = Logger.getLogger(ModeReplacement.class);
    private static ModeReplacement _instance;
    private CPNSimulation _simulation;
    CPNDrawingLoader _drawingLoader;
    GuiFinder _finder;

    private ModeReplacement() {
    }

    public CPNDrawingLoader getDrawingLoader() {
        if (this._drawingLoader == null) {
            this.setDrawingLoader(new CPNDrawingLoader());
        }
        return this._drawingLoader;
    }

    public static synchronized ModeReplacement getInstance() {
        if (_instance == null) {
            _instance = new ModeReplacement();
        }
        return _instance;
    }

    static synchronized void killInstance() {
        ModeReplacement oldInstance = _instance;
        _instance = null;
        if (oldInstance != null) {
            oldInstance.setDrawingLoader(null);
            oldInstance.getSimulation().dispose();
            oldInstance.setSimulation(null);
        }
    }

    public CPNSimulation getSimulation() {
        if (this._simulation == null) {
            this._simulation = new CPNSimulation(false, this.getDrawingLoader());
        }
        return this._simulation;
    }

    public void setSimulation(CPNSimulation sim) {
        this._simulation = sim;
    }

    public void setDrawingLoader(CPNDrawingLoader loader) {
        this._drawingLoader = loader;
        if (this._finder != null) {
            FinderRegistration.removeDefaultNetFinder((Finder)this._finder);
            this._finder = null;
        }
        if (this._drawingLoader != null && SimulatorPlugin.getCurrent() != null) {
            this._finder = new GuiFinder(this._drawingLoader);
            FinderRegistration.registerDefaultNetFinder((Finder)this._finder);
        }
    }

    public void formalismChanged(String newFormalism, Object st, int action) {
        if (action == 2) {
            if (this._simulation != null && this._simulation.isSimulationActive()) {
                logger.error((Object)"cannot change compiler: active simulation detected.");
            } else {
                CPNApplication app;
                if (this._simulation != null && this._simulation.getNetSystem() != null) {
                    FormalismPlugin fp = FormalismPlugin.getCurrent();
                    ShadowNetSystem netSystem = this._simulation.getNetSystem();
                    ShadowCompilerFactory compilerFactory = fp.getCompilerFactoryByName(fp.getCompiler());
                    ShadowNetSystemCompiler.getInstance().setDefaultCompilerFactory(compilerFactory, netSystem);
                }
                if ((app = GuiPlugin.getCurrent().getGui()) != null) {
                    EventQueue.invokeLater(() -> app.syntaxCheck());
                }
            }
        }
    }

    public ShadowCompilerFactory getDefaultCompilerFactory() {
        FormalismPlugin fp = FormalismPlugin.getCurrent();
        String currentCompiler = fp.getCompiler();
        if (currentCompiler != null) {
            return fp.getCompilerFactoryByName(currentCompiler);
        }
        return null;
    }
}

