/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.util.Command;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.ui.api.EditorApi;
import de.renew.draw.ui.api.ErrorApi;
import de.renew.gui.CPNApplication;
import de.renew.gui.GuiPlugin;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public class LayoutCheckCommand
extends Command {
    private static final Logger logger = Logger.getLogger(LayoutCheckCommand.class);
    private static final double OVERLAPWARNINGTHRESHOLD = 0.5;

    public LayoutCheckCommand(String name) {
        super(name);
    }

    public synchronized void execute() {
        try {
            CPNApplication application = (CPNApplication)DrawPlugin.getGui();
            Enumeration drawings = EditorApi.getCurrentDrawings();
            while (drawings.hasMoreElements()) {
                Drawing drawing = (Drawing)drawings.nextElement();
                this.checkSingleDrawing(drawing);
            }
        }
        catch (ClassCastException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private double overlap(Rectangle r1, Rectangle r2) {
        Rectangle intersection = r1.intersection(r2);
        if (intersection.isEmpty()) {
            return 0.0;
        }
        double intersectionArea = intersection.height * intersection.width;
        double r1Area = r1.height * r1.width;
        double r2Area = r2.height * r2.width;
        return Math.max(intersectionArea / r1Area, intersectionArea / r2Area);
    }

    private void checkSingleDrawing(Drawing drawing) {
        Vector<TextFigure> allTextFigures = new Vector<TextFigure>();
        FigureEnumeration figures = drawing.figures();
        boolean overlapFound = false;
        while (figures.hasMoreElements() && !overlapFound) {
            Figure figure = figures.nextFigure();
            if (!(figure instanceof TextFigure)) continue;
            TextFigure textFigure = (TextFigure)figure;
            Rectangle figureRectangle = figure.displayBox();
            for (TextFigure compareTextFigure : allTextFigures) {
                Rectangle compareRectangle = compareTextFigure.displayBox();
                overlapFound = this.overlap(figureRectangle, compareRectangle) > 0.5;
                if (!overlapFound) continue;
                GuiPlugin.getCurrent().processFigureException(ErrorApi.createErrorState((String)"Warning", (String)"Overlapping figures detected", (Drawing)drawing, (Figure)figure), true);
                break;
            }
            if (overlapFound) continue;
            allTextFigures.add(textFigure);
        }
        if (!overlapFound) {
            DrawPlugin.getGui().showStatus("Layout check successful");
        }
    }
}

