/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.standard.ToolButton;
import CH.ifa.draw.util.Palette;
import CH.ifa.draw.util.PaletteListener;
import de.renew.draw.ui.ontology.Tool;
import de.renew.draw.ui.ontology.Toolbar;
import de.renew.gui.CPNApplication;
import de.renew.gui.GuiPlugin;
import de.renew.gui.PaletteHolder;
import de.renew.gui.TextFigureToolButtonRegistry;
import de.renew.windowmanagement.Workbench;
import java.awt.Component;
import java.util.LinkedHashSet;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;

public class GuiPalettes
implements PaletteHolder {
    private static final Logger logger = Logger.getLogger(GuiPalettes.class);
    private final TextFigureToolButtonRegistry textFigureToolButtonRegistry;
    private final Vector<Palette> _palettes = new Vector();
    private final GuiPlugin _plugin;
    private final Workbench _workbench;
    final GuiEventDelegator _eventDelegator = new GuiEventDelegator();

    public GuiPalettes(Workbench workbench, GuiPlugin plugin) {
        this._plugin = plugin;
        this._workbench = workbench;
        this.textFigureToolButtonRegistry = new TextFigureToolButtonRegistry();
    }

    void notifyGuiOpen() {
        for (Palette toAdd : this._palettes) {
            this.internalAddPalette(toAdd);
        }
    }

    @Override
    public void addPalette(Palette toAdd) {
        this._palettes.add(toAdd);
        this.internalAddPalette(toAdd);
    }

    private void internalAddPalette(Palette toAdd) {
        logger.debug((Object)("-> GuiPlugin: registering palette " + String.valueOf(toAdd)));
        if (this._plugin.isGuiPresent()) {
            Component c = toAdd.getComponent();
            if (c instanceof JToolBar) {
                JToolBar bar = (JToolBar)c;
                Component[] components = bar.getComponents();
                LinkedHashSet<AbstractButton> set = new LinkedHashSet<AbstractButton>();
                for (Component comp : components) {
                    set.add((AbstractButton)comp);
                }
                Toolbar toolbar = this._plugin.getGui().getToolbar();
                toolbar.addTools(set, bar.getName());
            } else {
                JPanel panel = new JPanel();
                panel.add(c);
                this._workbench.addStaticPanel(panel);
            }
        }
    }

    @Override
    public void removePalette(Palette toRemove) {
        Component c;
        logger.debug((Object)("-> GuiPlugin: removing palette " + String.valueOf(toRemove)));
        this._palettes.remove(toRemove);
        if (this._plugin.isGuiPresent() && (c = toRemove.getComponent()) instanceof JToolBar) {
            JToolBar bar = (JToolBar)c;
            Toolbar toolbar = this._plugin.getGui().getToolbar();
            toolbar.removeTools(bar.getName());
        }
    }

    @Override
    public ToolButton createToolButton(Icon icon, Icon selectedIcon, String toolName, Tool tool) {
        logger.debug((Object)("the delegator is " + String.valueOf(this._eventDelegator)));
        return new ToolButton((PaletteListener)this._eventDelegator, icon, selectedIcon, toolName, tool);
    }

    @Override
    public ToolButton createToolButton(String path, String toolName, Tool tool) {
        return new ToolButton((PaletteListener)this._eventDelegator, path, toolName, tool);
    }

    @Override
    public TextFigureToolButtonRegistry getTextFigureToolButtonRegistry() {
        return this.textFigureToolButtonRegistry;
    }

    private static class GuiEventDelegator
    implements PaletteListener {
        private GuiEventDelegator() {
        }

        public void paletteUserOver(ToolButton button, boolean inside) {
            CPNApplication gui = GuiPlugin.getCurrent().getGui();
            if (gui != null) {
                gui.paletteUserOver(button, inside);
            }
        }

        public void paletteUserSelected(ToolButton button, boolean inside) {
            CPNApplication gui = GuiPlugin.getCurrent().getGui();
            if (gui != null) {
                gui.paletteUserSelected(button, inside);
            }
        }
    }
}

