/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.util.ColorMap;
import de.renew.draw.storables.ontology.Figure;
import de.renew.gui.TokenHandle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class ClickHandle
extends AbstractHandle
implements TokenHandle {
    protected Rectangle box;
    protected final Color fillColor;
    protected final Color penColor;

    protected ClickHandle(Figure owner, Color fillColor, Color penColor, Rectangle box) {
        super(owner);
        this.fillColor = fillColor;
        this.penColor = penColor;
        this.box = box;
    }

    public Point getOffset() {
        return this.box.getLocation();
    }

    public void setBox(Rectangle box) {
        this.box = box;
    }

    public Point locate() {
        Rectangle dbox = this.displayBox();
        return new Point(dbox.x + dbox.width / 2, dbox.y + dbox.height / 2);
    }

    public Rectangle displayBox() {
        Rectangle fsbox = this.owner().displayBox();
        return new Rectangle(this.box.x + fsbox.x, this.box.y + fsbox.y, this.box.width, this.box.height);
    }

    protected void drawInner(Graphics g) {
    }

    public void draw(Graphics g) {
        Rectangle fsbox = this.owner().displayBox();
        g.translate(fsbox.x, fsbox.y);
        if (!ColorMap.NONE.equals(this.fillColor)) {
            g.setColor(this.fillColor);
            g.fillRect(this.box.x, this.box.y, this.box.width, this.box.height);
        }
        if (!ColorMap.NONE.equals(this.penColor)) {
            g.setColor(this.penColor);
            g.drawRect(this.box.x, this.box.y, this.box.width - 1, this.box.height - 1);
        }
        this.drawInner(g);
        g.translate(-fsbox.x, -fsbox.y);
    }
}

