/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.io.StorableInputDrawingLoader;
import de.renew.draw.storables.api.StorableApi;
import de.renew.draw.storables.ontology.FigureChangeListener;
import de.renew.draw.storables.ontology.Storable;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.ModeReplacement;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import de.renew.gui.VirtualPlaceFigure;
import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EventListener;
import java.util.Vector;

public class CPNDrawingHelper {
    public PlaceFigure createPlace() {
        PlaceFigure result = new PlaceFigure();
        Dimension defaultDimension = PlaceFigure.defaultDimension();
        result.displayBox(new Point(0, 0), new Point((int)defaultDimension.getWidth(), (int)defaultDimension.getHeight()));
        return result;
    }

    public VirtualPlaceFigure createVirtualPlace(PlaceFigure place) {
        VirtualPlaceFigure result = new VirtualPlaceFigure(place);
        Dimension defaultDimension = PlaceFigure.defaultDimension();
        result.displayBox(new Point(0, 0), new Point((int)defaultDimension.getWidth(), (int)defaultDimension.getHeight()));
        return result;
    }

    public TransitionFigure createTransition() {
        TransitionFigure result = new TransitionFigure();
        Dimension defaultDimension = TransitionFigure.defaultDimension();
        result.displayBox(new Point(0, 0), new Point((int)defaultDimension.getWidth(), (int)defaultDimension.getHeight()));
        return result;
    }

    public ArcConnection createArcConnection(AttributeFigure start, AttributeFigure end, int type) {
        ArcConnection result = new ArcConnection(type);
        result.startPoint(0, 0);
        result.endPoint(0, 0);
        result.connectStart(start.connectorAt(start.center()));
        result.connectEnd(end.connectorAt(end.center()));
        result.updateConnection();
        return result;
    }

    public ArcConnection createArcConnection(AttributeFigure start, AttributeFigure end) {
        return this.createArcConnection(start, end, 1);
    }

    public CPNTextFigure createNameTextFigure(String name, ParentFigure parent) {
        CPNTextFigure result = new CPNTextFigure(2);
        result.setText(name);
        result.setParent(parent);
        result.moveBy(0, -20);
        return result;
    }

    public CPNTextFigure createInscription(String inscription, ParentFigure parent) {
        CPNTextFigure result = new CPNTextFigure(1);
        result.setText(inscription);
        result.setParent(parent);
        return result;
    }

    public CPNTextFigure createWeightTextFigure(ArcConnection arcConnection, int weight) {
        CPNTextFigure result = new CPNTextFigure(1);
        result.setText("[];".repeat(Math.max(0, weight)));
        result.setParent(arcConnection);
        return result;
    }

    public Vector<ArcConnection> getConnectedArcs(AttributeFigure fig) {
        FigureChangeListener[] listeners;
        Vector<ArcConnection> arcs = new Vector<ArcConnection>();
        for (FigureChangeListener listener : listeners = (FigureChangeListener[])AWTEventMulticaster.getListeners((EventListener)fig.listener(), FigureChangeListener.class)) {
            ArcConnection arc;
            if (!(listener instanceof ArcConnection) || !(arc = (ArcConnection)listener).startFigure().equals(fig) && !arc.endFigure().equals(fig)) continue;
            arcs.add(arc);
        }
        return arcs;
    }

    public static String netAsString(CPNDrawing d) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        d.lock();
        try {
            StorableOutput output = StorableApi.createStorableOutput((OutputStream)out);
            output.writeInt(12);
            output.writeStorable((Storable)d);
            output.close();
            d.clearModified();
        }
        finally {
            d.unlock();
        }
        return ((Object)out).toString();
    }

    public static CPNDrawing netFromString(String net, boolean registerForSimulation) throws IOException {
        CPNDrawing d;
        if (net == null || net.trim().length() < 10) {
            return null;
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(net.getBytes());){
            StorableInput si = StorableApi.createPatchingStorableInput((InputStream)in);
            d = (CPNDrawing)StorableInputDrawingLoader.readStorableDrawing((StorableInput)si);
            d.invalidate();
            if (registerForSimulation) {
                ModeReplacement.getInstance().getDrawingLoader().addDrawing(d);
            }
        }
        return d;
    }
}

