/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.ConnectedTextTool;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.standard.ConnectionTool;
import CH.ifa.draw.standard.StandardDrawingEditor;
import CH.ifa.draw.standard.StandardDrawingLookup;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.standard.StandardDrawingViewContainer;
import CH.ifa.draw.standard.ToolButton;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.event.CVetoClosingEvent;
import bibliothek.gui.dock.common.event.CVetoClosingListener;
import bibliothek.gui.dock.common.intern.CDockable;
import de.renew.draw.storables.ontology.ConnectionFigure;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.draw.ui.ontology.Tool;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNDrawingViewFactory;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.DeclarationFigure;
import de.renew.gui.DoubleArcConnection;
import de.renew.gui.DrawingEvent;
import de.renew.gui.DrawingListener;
import de.renew.gui.GuiPlugin;
import de.renew.gui.InstanceDrawing;
import de.renew.gui.ModeReplacement;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TokenBagDrawing;
import de.renew.gui.TransitionFigure;
import de.renew.gui.tool.CPNSelectionTool;
import de.renew.gui.tool.CPNTextTool;
import de.renew.gui.tool.DefaultSizeCreationTool;
import de.renew.gui.tool.VirtualPlaceFigureCreationTool;
import de.renew.gui.tool.VirtualTransitionFigureCreationTool;
import de.renew.gui.tool.ZoomAreaTool;
import de.renew.gui.tool.ZoomInTool;
import de.renew.gui.tool.ZoomOutTool;
import de.renew.gui.tool.ZoomResetTool;
import de.renew.windowmanagement.Workbench;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class CPNDrawingEditor
extends StandardDrawingEditor
implements CVetoClosingListener {
    private static final Color TOKEN_BAG_COLOR = new Color(230, 230, 255);
    private static final Color INSTANCE_COLOR = new Color(200, 200, 255);
    public static final String CPN_FACTORY_ID = "CPNDrawingViewFactory";
    private ToolButton fInscrTB;
    private ToolButton fNameTB;
    private ToolButton fDeclTB;
    private ToolButton fCommTB;
    private ToolButton fAuxTB;
    private final CPNDrawingViewFactory fFactory;
    private final GuiPlugin fGuiPlugin;
    private final transient Vector<DrawingListener> _fDrawingListeners;

    public CPNDrawingEditor(GuiPlugin guiPlugin, Workbench workbench) {
        super(workbench);
        this.fGuiPlugin = guiPlugin;
        this.fFactory = new CPNDrawingViewFactory(this);
        workbench.registerEditorFactory((MultipleCDockableFactory)this.fFactory, CPN_FACTORY_ID);
        this.registerDrawingViewFactoryID(CPNDrawing.class, CPN_FACTORY_ID);
        this.registerDrawingViewFactoryID(CPNInstanceDrawing.class, CPN_FACTORY_ID);
        this.registerDrawingViewFactoryID(TokenBagDrawing.class, CPN_FACTORY_ID);
        workbench.registerVetoClosingListener((CVetoClosingListener)this);
        this.createTools();
        this.createZoomTools();
        this._fDrawingListeners = new Vector();
    }

    public void added(CControl cControl, CDockable cDockable) {
        super.added(cControl, cDockable);
        if (cDockable instanceof StandardDrawingViewContainer) {
            StandardDrawingViewContainer container = (StandardDrawingViewContainer)cDockable;
            Drawing drawing = container.getView().drawing();
            if (drawing instanceof CPNDrawing) {
                CPNDrawing cpnDrawing = (CPNDrawing)drawing;
                ModeReplacement.getInstance().getDrawingLoader();
                LOGGER.debug((Object)("drawing loaded: " + drawing.getName()));
                ModeReplacement.getInstance().getDrawingLoader().addDrawing(cpnDrawing);
            }
            if (drawing instanceof TokenBagDrawing) {
                this.noUndoHistoryFor(drawing);
            }
        }
    }

    public void opened(CControl cControl, CDockable cDockable) {
        StandardDrawingViewContainer container;
        Drawing drawing;
        super.opened(cControl, cDockable);
        if (cDockable instanceof StandardDrawingViewContainer && (drawing = (container = (StandardDrawingViewContainer)cDockable).getView().drawing()) instanceof InstanceDrawing) {
            InstanceDrawing instanceDrawing = (InstanceDrawing)drawing;
            StandardDrawingViewContainer netpattern = this.getDrawingLookup().getViewContainerForDrawing((Drawing)instanceDrawing.getCpnDrawing());
            container.setLocationsAside((CDockable)netpattern);
            Dimension patternViewportSize = netpattern.getScrollPane().getViewport().getViewSize();
            container.getScrollPane().getViewport().setViewSize(patternViewportSize);
            Point patternViewportPosition = netpattern.getScrollPane().getViewport().getViewPosition();
            container.getScrollPane().getViewport().setViewPosition(patternViewportPosition);
            double patternScalingFactor = netpattern.getView().getScalingFactor();
            container.getView().changeScalingFactor(patternScalingFactor);
            container.getView().setBackground(INSTANCE_COLOR);
            this.noUndoHistoryFor(drawing);
        }
    }

    public void removed(CControl cControl, CDockable cDockable) {
        super.removed(cControl, cDockable);
        if (cDockable instanceof StandardDrawingViewContainer) {
            StandardDrawingViewContainer container = (StandardDrawingViewContainer)cDockable;
            Drawing drawing = container.getView().drawing();
            if (drawing instanceof CPNDrawing) {
                CPNDrawing cpnDrawing = (CPNDrawing)drawing;
                ModeReplacement.getInstance().getDrawingLoader().releaseDrawing(cpnDrawing);
            }
            container.clean();
        }
    }

    public void showNetPatternDrawing(String netName, int elementID) {
        StandardDrawingLookup lookup = this.getDrawingLookup();
        Enumeration drawenumeration = lookup.getAllDrawings();
        CPNDrawing drawing = null;
        while (drawenumeration.hasMoreElements() && drawing == null) {
            CPNDrawing cpnDrawing;
            Object next = drawenumeration.nextElement();
            if (!(next instanceof CPNDrawing) || !(cpnDrawing = (CPNDrawing)next).getName().equals(netName)) continue;
            drawing = cpnDrawing;
        }
        if (drawing == null) {
            drawing = ModeReplacement.getInstance().getDrawingLoader().getDrawing(netName);
        }
        if (drawing != null) {
            FigureWithID elementFigure;
            this.openDrawing(drawing);
            lookup.getViewContainerForDrawing((Drawing)drawing).toFront();
            if (elementID != 0 && (elementFigure = drawing.getFigureWithID(elementID)) != null) {
                StandardDrawingView elementView = lookup.getViewContainerForDrawing((Drawing)drawing).getView();
                elementView.clearSelection();
                elementView.addToSelection((Figure)elementFigure);
                elementView.repairDamage();
            }
        }
    }

    public void openTokenBagDrawing(TokenBagDrawing tokenBagDrawing, InstanceDrawing instanceDrawing) {
        this.openDrawing((Drawing)tokenBagDrawing);
        StandardDrawingViewContainer container = this.getDrawingLookup().getViewContainerForDrawing((Drawing)tokenBagDrawing);
        StandardDrawingView view = container.getView();
        view.setBackground(TOKEN_BAG_COLOR);
        StandardDrawingViewContainer instancecontainer = this.getDrawingLookup().getViewContainerForDrawing((Drawing)instanceDrawing);
        container.setLocationsAside((CDockable)instancecontainer);
    }

    public void closing(CVetoClosingEvent cVetoClosingEvent) {
        Iterator it = cVetoClosingEvent.iterator();
        while (it.hasNext() && !cVetoClosingEvent.isCanceled()) {
            CPNDrawing cpnDrawing;
            Enumeration<InstanceDrawing> dependentDrawings;
            StandardDrawingViewContainer standardDrawingViewContainer;
            Drawing drawing;
            CDockable dockable = (CDockable)it.next();
            if (!(dockable instanceof StandardDrawingViewContainer) || !((drawing = (standardDrawingViewContainer = (StandardDrawingViewContainer)dockable).getView().drawing()) instanceof CPNDrawing) || (dependentDrawings = CPNInstanceDrawing.getDependentInstanceDrawings(cpnDrawing = (CPNDrawing)drawing)) == null) continue;
            this.openDrawing(drawing);
            int answer = JOptionPane.showConfirmDialog(this.fWorkbench.getMainFrame(), new String[]{"The drawing \"" + drawing.getName() + "\" you are about to close", "is needed to display one or more instance drawings."}, "Renew: Confirm Close", 2);
            if (answer == 2) {
                cVetoClosingEvent.cancel();
                continue;
            }
            while (dependentDrawings.hasMoreElements()) {
                this.closeDrawing(dependentDrawings.nextElement());
            }
        }
    }

    public void closed(CVetoClosingEvent cVetoClosingEvent) {
        Iterator it = cVetoClosingEvent.iterator();
        while (it.hasNext() && !cVetoClosingEvent.isCanceled()) {
            CDockable dockable = (CDockable)it.next();
            if (!(dockable instanceof StandardDrawingViewContainer)) continue;
            StandardDrawingViewContainer container = (StandardDrawingViewContainer)dockable;
            Drawing drawing = container.getView().drawing();
            drawing.release();
            this.notifyDrawingListeners(drawing, false);
        }
    }

    protected void createTools() {
        LinkedHashMap list = new LinkedHashMap();
        Object tool = new DefaultSizeCreationTool((DrawingEditor)this, TransitionFigure::new, TransitionFigure.defaultDimension());
        list.put(this.createToolButton(this.loadImageIcon("TRANS"), null, "Transition Tool", (Tool)tool).button(), null);
        if (this.fGuiPlugin.getProperties().getBoolProperty("de.renew.gui.virtualTransition")) {
            tool = new VirtualTransitionFigureCreationTool((DrawingEditor)this);
            list.put(this.createToolButton(this.loadImageIcon("VTRANS"), null, "Virtual Transition Tool", (Tool)tool).button(), null);
        }
        tool = new DefaultSizeCreationTool((DrawingEditor)this, PlaceFigure::new, PlaceFigure.defaultDimension());
        list.put(this.createToolButton(this.loadImageIcon("PLACE"), null, "Place Tool", (Tool)tool).button(), null);
        tool = new VirtualPlaceFigureCreationTool((DrawingEditor)this);
        list.put(this.createToolButton(this.loadImageIcon("VPLACE"), null, "Virtual Place Tool", (Tool)tool).button(), null);
        tool = new ConnectionTool((DrawingEditor)this, (ConnectionFigure)ArcConnection.NormalArc);
        list.put(this.createToolButton(this.loadImageIcon("ARC"), null, "Arc Tool", (Tool)tool).button(), null);
        tool = new ConnectionTool((DrawingEditor)this, (ConnectionFigure)ArcConnection.TestArc);
        list.put(this.createToolButton("CH/ifa/draw/images/LINE", "Test Arc Tool", (Tool)tool).button(), null);
        tool = new ConnectionTool((DrawingEditor)this, (ConnectionFigure)ArcConnection.ReserveArc);
        list.put(this.createToolButton("CH/ifa/draw/images/CONN", "Reserve Arc Tool", (Tool)tool).button(), null);
        tool = new ConnectionTool((DrawingEditor)this, (ConnectionFigure)DoubleArcConnection.DoubleArc);
        list.put(this.createToolButton(this.loadImageIcon("DARC"), null, "Flexible Arc Tool", (Tool)tool).button(), null);
        tool = new CPNTextTool((DrawingEditor)this, CPNTextFigure.Inscription);
        this.fInscrTB = this.createToolButton(this.loadImageIcon("INSCR"), null, "Inscription Tool", (Tool)tool);
        list.put(this.fInscrTB.button(), null);
        tool = new ConnectedTextTool((DrawingEditor)this, (TextFigure)CPNTextFigure.Name);
        this.fNameTB = this.createToolButton(this.loadImageIcon("NAME"), null, "Name Tool", (Tool)tool);
        list.put(this.fNameTB.button(), null);
        tool = new CPNTextTool((DrawingEditor)this, new DeclarationFigure(), false);
        this.fDeclTB = this.createToolButton(this.loadImageIcon("DECL"), null, "Declaration Tool", (Tool)tool);
        list.put(this.fDeclTB.button(), null);
        tool = new CPNTextTool((DrawingEditor)this, CPNTextFigure.Comm);
        this.fCommTB = this.createToolButton(this.loadImageIcon("COMM"), null, "Comment Tool", (Tool)tool);
        list.put(this.fCommTB.button(), null);
        String description = "<html><b>Petri Net Tools</b><br>Tools to draw P/T nets<br>or similar net types.</html>";
        this.getToolbar().addTools(list.keySet(), "Petri Net Tools", description);
    }

    private void createZoomTools() {
        LinkedHashSet<AbstractButton> buttons = new LinkedHashSet<AbstractButton>();
        buttons.add(this.createToolButton(this.loadImageIcon("ZOOMIN"), null, "Zoom In Tool", (Tool)new ZoomInTool((DrawingEditor)this)).button());
        buttons.add(this.createToolButton(this.loadImageIcon("ZOOMOUT"), null, "Zoom Out Tool", (Tool)new ZoomOutTool((DrawingEditor)this)).button());
        buttons.add(this.createToolButton(this.loadImageIcon("ZOOMRESET"), null, "Zoom Reset Tool", (Tool)new ZoomResetTool((DrawingEditor)this)).button());
        buttons.add(this.createToolButton(this.loadImageIcon("ZOOMAREA"), null, "Zoom Area Tool", (Tool)new ZoomAreaTool((DrawingEditor)this)).button());
        String description = "<html><b>Zoom Tools</b><br>Tools to zoom in the drawing editor.</html>";
        this.getToolbar().addTools(buttons, "Zoom Tools", description);
    }

    protected ImageIcon loadImageIcon(String iconName) {
        URL resource = ((Object)((Object)this)).getClass().getResource("/de/renew/gui/images/" + iconName + ".gif");
        return new ImageIcon(resource);
    }

    protected Tool createSelectionTool() {
        return new CPNSelectionTool((DrawingEditor)this);
    }

    public ToolButton toolButtonForTextFigure(TextFigure figure) {
        if (figure instanceof CPNTextFigure) {
            if (figure instanceof DeclarationFigure) {
                return this.fDeclTB;
            }
            switch (((CPNTextFigure)figure).getType()) {
                case 3: {
                    if (this.fAuxTB != null) {
                        return this.fAuxTB;
                    }
                    return this.fInscrTB;
                }
                case 1: {
                    return this.fInscrTB;
                }
                case 2: {
                    return this.fNameTB;
                }
                case 4: {
                    return this.fCommTB;
                }
            }
        }
        return super.toolButtonForTextFigure(figure);
    }

    public Drawing newDrawing() {
        Drawing drawing = this.fFactory.create().drawing();
        return this.openDrawing(drawing);
    }

    public void addDrawingListener(DrawingListener listener) {
        this._fDrawingListeners.addElement(listener);
    }

    public void removeDrawingListener(DrawingListener listener) {
        this._fDrawingListeners.remove(listener);
    }

    public Drawing openDrawing(Drawing drawing) {
        this.notifyDrawingListeners(drawing, true);
        return super.openDrawing(drawing);
    }

    private void notifyDrawingListeners(Drawing drawing, boolean add) {
        for (int i = 0; i < this._fDrawingListeners.size(); ++i) {
            if (add) {
                this._fDrawingListeners.elementAt(i).drawingOpened(new DrawingEvent((Object)this, drawing));
                continue;
            }
            this._fDrawingListeners.elementAt(i).drawingClosed(new DrawingEvent((Object)this, drawing));
        }
    }
}

