/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.TextFigure;
import de.renew.draw.storables.ontology.Figure;
import de.renew.gui.FigureCreator;
import de.renew.gui.GuiPlugin;
import de.renew.gui.HorizontalCompositeFigure;
import de.renew.gui.NetInstanceHandle;
import de.renew.net.NetInstance;
import de.renew.remote.AggregateAccessor;
import de.renew.remote.ObjectAccessor;
import de.renew.unify.Aggregate;
import de.renew.unify.List;
import java.rmi.RemoteException;

public class AggregateFigure
extends HorizontalCompositeFigure {
    public AggregateFigure(AggregateAccessor aggregate, boolean expanded) throws RemoteException {
        FigureCreator fc = GuiPlugin.getCurrent().getFigureCreator();
        this.addAggregate(aggregate, fc, expanded);
        this.layout();
    }

    private void addAggregate(AggregateAccessor aggregate, FigureCreator fc, boolean expanded) throws RemoteException {
        ObjectAccessor openTail;
        boolean isList = aggregate.isInstanceOf(List.class);
        this.add((Figure)new TextFigure(isList ? "{" : "[", true));
        boolean first = true;
        AggregateAccessor.AggregateEnumerationAccessor elems = aggregate.elements();
        while (elems.hasMoreElements()) {
            if (first) {
                first = false;
            } else {
                this.add((Figure)new TextFigure(",", true));
            }
            ObjectAccessor token = elems.nextElement();
            if (token != null && token.isInstanceOf(Aggregate.class)) {
                this.addAggregate(token.asAggregate(), fc, expanded);
                continue;
            }
            Figure tokenFig = fc.getTokenFigure(token, expanded);
            this.add(tokenFig);
            if (token == null || !token.isInstanceOf(NetInstance.class)) continue;
            this.addClickHandle(new NetInstanceHandle(tokenFig, null, token.asNetInstance()));
        }
        if (isList && (openTail = elems.getOpenTail()) != null) {
            this.add((Figure)new TextFigure(":", true));
            this.add(fc.getTokenFigure(openTail, expanded));
        }
        this.add((Figure)new TextFigure(isList ? "}" : "]", true));
    }
}

