/*
 * Decompiled with CFR 0.152.
 */
package de.renew.export.io.exportFormats;

import CH.ifa.draw.io.DrawingFileHelper;
import de.renew.draw.storables.api.StorableApi;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.ui.ontology.StatusDisplayer;
import de.renew.ioontology.ExtensionFileFilter;
import de.renew.ioontology.FileFilter;
import de.renew.ioontology.exporting.ExportFormat;
import de.renew.ioontology.exporting.ExportFormatMultiAbstract;
import de.renew.plugin.command.CLCommand;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class ExportClCommand
implements CLCommand,
CH.ifa.draw.io.StatusDisplayer {
    private static final String SYNOPSIS = "Exports a drawing. Usage: ex <type> [drawing]+ [options]";
    private static final Logger LOGGER = Logger.getLogger(ExportClCommand.class);

    /*
     * WARNING - void declaration
     */
    public void execute(String[] args, PrintStream response) {
        DefaultParser parser = new DefaultParser();
        Options opts = new Options();
        opts.addOption("a", "accumulate", false, "n-to-1 export (only available for some formats, e.g. ShadowNetSystem)");
        opts.addOption("o", "output", true, "output file");
        List<ExportFormat<Drawing>> formats = this.flattenedExportFormats();
        CommandLine line = null;
        try {
            line = parser.parse(opts, args);
        }
        catch (ParseException e1) {
            response.append("Could not parse command.\n");
            this.printHelp(response, formats, opts);
            return;
        }
        List argList = line.getArgList();
        if (argList.size() < 2) {
            response.append("Not enough arguments.\n");
            this.printHelp(response, formats, opts);
            return;
        }
        String type = (String)argList.remove(0);
        List files = argList;
        boolean accumulate = line.hasOption("a");
        if (files.size() > 1 && line.hasOption("o") && !accumulate) {
            response.append("Cannot export multiple drawings with custom output file (except for n-to-1 export).\n");
            this.printHelp(response, formats, opts);
            return;
        }
        ExportFormat<Drawing> exportFormat = null;
        String extension = type;
        for (ExportFormat<Drawing> exportFormat2 : formats) {
            LOGGER.debug(exportFormat2);
            if (!exportFormat2.formatName().equalsIgnoreCase(type)) continue;
            exportFormat = exportFormat2;
            LOGGER.info((Object)(ExportClCommand.class.getSimpleName() + ": format is " + exportFormat2.formatName()));
            FileFilter fileFilter = exportFormat2.fileFilter();
            if (!(fileFilter instanceof ExtensionFileFilter)) break;
            extension = ((ExtensionFileFilter)fileFilter).getExtension();
            break;
        }
        if (exportFormat == null) {
            response.append("Export format not found.\n");
            return;
        }
        if (accumulate) {
            void var14_19;
            if (!exportFormat.canExportNto1()) {
                response.append("Export format does not support n-to-1 export.\n");
                return;
            }
            ArrayList<Drawing> drawings = new ArrayList<Drawing>();
            for (String filename : files) {
                LOGGER.info((Object)(ExportClCommand.class.getSimpleName() + ": add filename to n-to-1 export " + filename));
                File file = new File(filename);
                if (!file.exists()) continue;
                drawings.add(DrawingFileHelper.loadDrawing((File)file, (StatusDisplayer)this));
            }
            if (line.hasOption("o")) {
                File file = new File(line.getOptionValue("o"));
            } else {
                File file = new File(((Drawing)drawings.get(0)).getName() + ".sns");
            }
            this.saveDrawings(drawings, exportFormat, (File)var14_19);
            LOGGER.info((Object)(ExportClCommand.class.getSimpleName() + ": exported n-to-1  " + var14_19.getAbsolutePath()));
        } else if (line.hasOption("o")) {
            this.exportSingleDrawing(exportFormat, extension, (String)files.get(0), line.getOptionValue("o"));
        } else {
            for (String string : files) {
                this.exportSingleDrawing(exportFormat, extension, string, null);
            }
        }
    }

    public List<ExportFormat<Drawing>> flattenedExportFormats() {
        List formats = StorableApi.getExportFormats();
        LinkedList exportFormatsQueue = new LinkedList(formats);
        ArrayList<ExportFormat<Drawing>> flattenedExportFormats = new ArrayList<ExportFormat<Drawing>>();
        while (!exportFormatsQueue.isEmpty()) {
            ExportFormat format = (ExportFormat)exportFormatsQueue.poll();
            if (format instanceof ExportFormatMultiAbstract) {
                ExportFormatMultiAbstract multiFormat = (ExportFormatMultiAbstract)format;
                exportFormatsQueue.addAll(multiFormat.getExportFormats());
                continue;
            }
            flattenedExportFormats.add((ExportFormat<Drawing>)format);
        }
        flattenedExportFormats.sort(Comparator.comparing(ExportFormat::formatName));
        return flattenedExportFormats;
    }

    private void exportSingleDrawing(ExportFormat<Drawing> format, String extension, String filename, String outputFile) {
        LOGGER.info((Object)(ExportClCommand.class.getName() + ": filename is " + filename));
        File file = new File(filename);
        if (file.exists()) {
            Drawing drawing = DrawingFileHelper.loadDrawing((File)file, (StatusDisplayer)this);
            LOGGER.info((Object)(ExportClCommand.class.getName() + ": drawing is " + drawing.getName()));
            File exportFile = outputFile == null ? new File(drawing.getFilename().getAbsoluteFile().getParentFile(), drawing.getName() + "." + extension) : new File(outputFile);
            LOGGER.info((Object)(ExportClCommand.class.getName() + ": path is " + String.valueOf(exportFile)));
            this.saveDrawing(drawing, format, exportFile);
        }
    }

    public String getDescription() {
        return "Exports a drawing. Usage: ex <type> [drawing]+ [options] Type ex for a list of supported formats and options.";
    }

    public void showStatus(String message) {
        LOGGER.info((Object)(ExportClCommand.class.getName() + " Status: " + message));
    }

    public String getArguments() {
        List<ExportFormat<Drawing>> formats = this.flattenedExportFormats();
        Object arguments = "";
        if (formats.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            for (int i = 0; i < formats.size(); ++i) {
                ExportFormat<Drawing> format = formats.get(i);
                sb.append(format.formatName());
                if (i >= formats.size() - 1) continue;
                sb.append("|");
            }
            sb.append(")");
            sb.append(" ");
            arguments = sb.toString();
        }
        arguments = (String)arguments + "[fileNames|-o|-a]*";
        return arguments;
    }

    private void printHelp(PrintStream response, List<ExportFormat<Drawing>> formats, Options opts) {
        HelpFormatter formatter = new HelpFormatter();
        String header = "Exports a drawing.";
        formatter.printHelp(new PrintWriter(response, true), 74, "ex <type> [drawing]+", header, opts, 1, 3, null, true);
        response.append("List of available formats:\n");
        for (ExportFormat<Drawing> exportFormat : formats) {
            response.append(ExportClCommand.class.getSimpleName() + ": " + String.valueOf(exportFormat) + "\n");
            if (!exportFormat.canExportNto1()) continue;
            response.append(ExportClCommand.class.getSimpleName() + ": " + String.valueOf(exportFormat) + " -a file.rnw [morefiles.rnw] (n-to-1)\n");
        }
    }

    private void saveDrawing(Drawing drawing, ExportFormat<Drawing> format, File path) {
        try {
            File pathResult = format.export((Object)drawing, path);
            this.showStatus("Exported " + pathResult.getPath() + ".");
        }
        catch (Exception e) {
            this.showStatus(e.getMessage());
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void saveDrawings(List<Drawing> drawings, ExportFormat<Drawing> format, File path) {
        try {
            Object[] array = drawings.toArray(new Drawing[0]);
            format.export(array, path);
            this.showStatus("Exported " + path.getPath() + ".");
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            this.showStatus(e.toString());
            LOGGER.debug((Object)(this.getClass().getSimpleName() + ": "), (Throwable)e);
        }
    }
}

