/*
 * Decompiled with CFR 0.152.
 */
package de.renew.unify;

import de.renew.unify.IStateRecorder;
import de.renew.unify.IdentityWrapper;
import de.renew.unify.Impossible;
import de.renew.unify.Notifiable;
import de.renew.unify.Referable;
import de.renew.unify.Reference;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.IntStream;

class BacklinkSet
implements Serializable {
    private static final int MAX_BACKLINKS = 6;
    private int _cnt = 0;
    private final Reference[] _backlinks = new Reference[6];
    private Set<IdentityWrapper> _externalSet = null;

    BacklinkSet() {
    }

    private boolean includes(Reference reference) {
        if (this._externalSet != null) {
            return this._externalSet.contains(new IdentityWrapper(reference));
        }
        return IntStream.range(0, this._cnt).anyMatch(index -> this._backlinks[index] == reference);
    }

    private void includeNonElement(Reference reference) {
        if (this._externalSet == null && this._cnt == 6) {
            this._externalSet = new HashSet<IdentityWrapper>();
            for (int i = 0; i < 6; ++i) {
                this._externalSet.add(new IdentityWrapper(this._backlinks[i]));
            }
        }
        if (this._externalSet != null) {
            this._externalSet.add(new IdentityWrapper(reference));
        } else {
            this._backlinks[this._cnt++] = reference;
        }
    }

    private void exclude(Reference reference) {
        if (this._externalSet != null) {
            this._externalSet.remove(new IdentityWrapper(reference));
        } else {
            --this._cnt;
            if (this._backlinks[this._cnt] != reference) {
                if (this._backlinks[0] == reference) {
                    this._backlinks[0] = this._backlinks[this._cnt];
                } else if (this._backlinks[1] == reference) {
                    this._backlinks[1] = this._backlinks[this._cnt];
                } else if (this._backlinks[2] == reference) {
                    this._backlinks[2] = this._backlinks[this._cnt];
                } else {
                    throw new RuntimeException("Backlink not found. Strange. ");
                }
            }
            this._backlinks[this._cnt] = null;
        }
    }

    int size() {
        if (this._externalSet != null) {
            return this._externalSet.size();
        }
        return this._cnt;
    }

    void addBacklink(Reference reference, IStateRecorder recorder) {
        if (!this.includes(reference)) {
            this.includeNonElement(reference);
            if (recorder != null) {
                recorder.record(() -> this.exclude(reference));
            }
        }
    }

    void updateBacklinked(Referable oldValue, Object newValue, Set<Notifiable> listeners, IStateRecorder recorder) throws Impossible {
        if (this._externalSet != null) {
            for (IdentityWrapper wrapper : this._externalSet) {
                Reference reference = (Reference)wrapper.getObject();
                reference.update(oldValue, newValue, listeners, recorder);
            }
        } else {
            for (int i = 0; i < this._cnt; ++i) {
                this._backlinks[i].update(oldValue, newValue, listeners, recorder);
            }
        }
    }
}

