/*
 * Decompiled with CFR 0.152.
 */
package de.renew.shadowcompiler;

import de.renew.simulatorontology.loading.Finder;
import de.renew.simulatorontology.shadow.ShadowNet;
import de.renew.simulatorontology.shadow.ShadowNetSystem;
import de.renew.util.ClassSource;
import de.renew.util.ObjectInputStreamUsingBottomLoader;
import de.renew.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class SNSFinder
extends Finder {
    private static final Logger LOGGER = Logger.getLogger(SNSFinder.class);
    private final String[] _shadowExtensions = new String[]{".sns", ".sha"};

    public ShadowNetSystem findNetFile(String name, String path) {
        boolean error = true;
        URL url = null;
        for (int ext = 0; error && ext < this._shadowExtensions.length; ++ext) {
            error = false;
            String fullFileName = path + this._shadowExtensions[ext];
            LOGGER.debug((Object)("SNSFinder: looking for: " + fullFileName));
            try {
                File file = new File(fullFileName);
                if (file.canRead()) {
                    url = file.toURI().toURL();
                } else {
                    error = true;
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("SNSFinder: " + fullFileName + " caused " + String.valueOf(e)));
                LOGGER.debug((Object)e.getMessage(), (Throwable)e);
                error = true;
            }
            if (error) continue;
            try {
                ShadowNetSystem netSystem = this.loadNetSystemFromURL(url, name);
                if (netSystem == null) continue;
                return netSystem;
            }
            catch (Exception e) {
                LOGGER.error((Object)("SNSFinder: " + String.valueOf(url) + " caused " + String.valueOf(e)));
                LOGGER.debug((Object)e.getMessage(), (Throwable)e);
                error = true;
            }
        }
        return null;
    }

    public ShadowNetSystem findNetClasspathRel(String name, String path) {
        boolean error = true;
        for (int ext = 0; error && ext < this._shadowExtensions.length; ++ext) {
            error = false;
            String fullFileName = path + this._shadowExtensions[ext];
            LOGGER.debug((Object)("SNSFinder: looking for: " + fullFileName));
            URL url = ClassSource.getClassLoader().getResource(StringUtil.convertToSlashes((String)fullFileName));
            boolean bl = error = url == null;
            if (error) continue;
            try {
                ShadowNetSystem netSystem = this.loadNetSystemFromURL(url, name);
                if (netSystem == null) continue;
                return netSystem;
            }
            catch (Exception e) {
                LOGGER.error((Object)("SNSFinder: " + String.valueOf(url) + " caused " + String.valueOf(e)));
                LOGGER.debug((Object)e.getMessage(), (Throwable)e);
                error = true;
            }
        }
        return null;
    }

    private ShadowNetSystem loadNetSystemFromURL(URL url, String name) throws IOException, ClassNotFoundException {
        LOGGER.debug((Object)("Loading shadow net from " + String.valueOf(url)));
        InputStream stream = url.openStream();
        ObjectInputStreamUsingBottomLoader input = new ObjectInputStreamUsingBottomLoader(stream);
        ShadowNetSystem netSystem = (ShadowNetSystem)input.readObject();
        input.close();
        Iterator nets = netSystem.elements().iterator();
        if (nets.hasNext()) {
            ShadowNet net = (ShadowNet)nets.next();
            if (nets.hasNext()) {
                LOGGER.error((Object)("SNSFinder: " + String.valueOf(url) + " contains more than one shadow net. Ignored."));
            } else if (net.getName().equals(name)) {
                LOGGER.debug((Object)("SNSFinder: found net " + name + " at " + String.valueOf(url)));
                return netSystem;
            }
        }
        LOGGER.warn((Object)("SNSFinder: " + String.valueOf(url) + " was empty!? Ignored."));
        return null;
    }
}

