/*
 * Decompiled with CFR 0.152.
 */
package de.renew.shadowcompiler;

import de.renew.shadowcompiler.SNSFinder;
import de.renew.shadowcompiler.ShadowNetSystemCompiler;
import de.renew.simulatorontology.loading.Finder;
import de.renew.simulatorontology.loading.NetNotFoundException;
import de.renew.simulatorontology.loading.PathlessFinder;
import de.renew.simulatorontology.shadow.ShadowNet;
import de.renew.simulatorontology.shadow.ShadowNetLoader;
import de.renew.simulatorontology.shadow.ShadowNetSystem;
import de.renew.util.PathEntry;
import de.renew.util.StringUtil;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class DefaultShadowNetLoader
implements ShadowNetLoader {
    private static final Logger LOGGER = Logger.getLogger(DefaultShadowNetLoader.class);
    private final Set<Finder> _finders = new LinkedHashSet<Finder>();
    private final Set<PathlessFinder> _pathlessFinders = new LinkedHashSet<PathlessFinder>();
    private PathEntry[] _netSource;

    public DefaultShadowNetLoader(Properties props) {
        this.registerFinder(new SNSFinder());
        if (props != null) {
            this.configureNetPath(props);
        } else {
            this.configureNetPath(System.getProperties());
        }
    }

    public void configureNetPath(Properties props) {
        this.setNetPath(props.getProperty("de.renew.netPath", System.getProperty("user.dir")));
    }

    void setNetPath(String path) {
        this.setNetPath(StringUtil.splitPaths((String)path));
    }

    void setNetPath(String[] paths) {
        for (PathEntry pathEntry : this._netSource = StringUtil.canonizePaths((String[])paths)) {
            LOGGER.debug((Object)("Shadow net loader source" + (pathEntry.isClasspathRelative ? " (relative to CLASSPATH): " : ": ") + pathEntry.path));
        }
    }

    public static String asPathString(PathEntry[] paths) {
        if (paths == null || paths.length == 0) {
            return "";
        }
        boolean first = true;
        StringBuilder builder = new StringBuilder();
        for (PathEntry path : paths) {
            if (path == null) continue;
            if (first) {
                first = false;
            } else {
                builder.append(File.pathSeparator);
            }
            if (path.isClasspathRelative) {
                builder.append("CLASSPATH");
                if (!"".equals(path.path)) {
                    builder.append(File.separator);
                }
            }
            builder.append(path.path);
        }
        return builder.toString();
    }

    public ShadowNetSystem loadShadowNetSystem(String netName) throws NetNotFoundException {
        ShadowNetSystem loaded = this.findShadowNetSystemFile(netName);
        if (loaded != null) {
            return loaded;
        }
        throw new NetNotFoundException(netName);
    }

    public ShadowNet loadShadowNet(String netName, ShadowNetSystem netSystem) throws NetNotFoundException {
        ShadowNetSystem foundNetSystem = this.loadShadowNetSystem(netName);
        ShadowNet foundNet = (ShadowNet)foundNetSystem.elements().iterator().next();
        if (foundNet != null && netName.equals(foundNet.getName())) {
            ShadowNetSystemCompiler.getInstance().switchNetSystem(foundNet, netSystem);
            return foundNet;
        }
        throw new NetNotFoundException(netName);
    }

    public ShadowNetSystem findShadowNetSystemFile(String name) {
        ShadowNetSystem theNetSystem;
        for (PathlessFinder finder : this._pathlessFinders) {
            LOGGER.debug((Object)("Searching for net " + name + " in pathless finder " + String.valueOf(finder)));
            theNetSystem = finder.findNetFile(name);
            if (theNetSystem == null || theNetSystem.elements().isEmpty()) continue;
            return theNetSystem;
        }
        for (PathEntry pathEntry : this._netSource) {
            StringBuilder builder = new StringBuilder();
            builder.append(pathEntry.path);
            if (!"".equals(pathEntry.path)) {
                builder.append(File.separator);
            }
            builder.append(name);
            String path = builder.toString();
            for (Finder finder : this._finders) {
                LOGGER.debug((Object)("Searching for net " + String.valueOf(builder) + " in finder " + String.valueOf(finder)));
                theNetSystem = pathEntry.isClasspathRelative ? finder.findNetClasspathRel(name, path) : finder.findNetFile(name, path);
                if (theNetSystem == null || theNetSystem.elements().isEmpty()) continue;
                return theNetSystem;
            }
        }
        return null;
    }

    public boolean registerFinder(Finder finder) {
        return this._finders.add(finder);
    }

    public boolean removeFinder(Finder finder) {
        return this._finders.remove(finder);
    }

    public boolean registerPathlessFinder(PathlessFinder finder) {
        return this._pathlessFinders.add(finder);
    }

    public boolean removePathlessFinder(PathlessFinder finder) {
        return this._pathlessFinders.remove(finder);
    }
}

