/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.serialisation;

import de.renew.net.INetLookup;
import de.renew.net.Net;
import de.renew.net.serialisation.INetSerializer;
import de.renew.simulator.api.ISimulationLockExecutor;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Optional;

public class NetSerializer
implements INetSerializer {
    private final ISimulationLockExecutor _lockExecutor;
    private final INetLookup _netLookup;

    public NetSerializer(ISimulationLockExecutor lockExecutor, INetLookup netLookup) {
        this._lockExecutor = lockExecutor;
        this._netLookup = netLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAllKnownNets(ObjectOutput outputStream) throws IOException {
        this._lockExecutor.lock();
        try {
            Optional<Object> renewObjectOutputStream = Optional.empty();
            if (outputStream instanceof RenewObjectOutputStream) {
                renewObjectOutputStream = Optional.of((RenewObjectOutputStream)outputStream);
            }
            renewObjectOutputStream.ifPresent(stream -> stream.beginDomain(Net.class));
            Collection<Net> allKnownNets = this._netLookup.getAllKnownNets();
            outputStream.writeInt(allKnownNets.size());
            for (Net net : allKnownNets) {
                outputStream.writeObject(net);
            }
            if (renewObjectOutputStream.isPresent()) {
                ((RenewObjectOutputStream)renewObjectOutputStream.get()).writeDelayedObjects();
                ((RenewObjectOutputStream)renewObjectOutputStream.get()).endDomain(Net.class);
            }
        }
        finally {
            this._lockExecutor.unlock();
        }
    }
}

