/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.inscription.arc;

import de.renew.engine.common.SimulatorEventLogger;
import de.renew.engine.events.PlaceEvent;
import de.renew.engine.events.QuicklyTesting;
import de.renew.engine.events.SimulationEvent;
import de.renew.engine.events.Testing;
import de.renew.engine.searcher.EarlyExecutable;
import de.renew.net.PlaceInstance;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.simulatorontology.simulation.StepIdentifier;
import de.renew.unify.Impossible;

class TestArcExecutable
implements EarlyExecutable {
    private final SimulatablePlaceInstance _placeInstance;
    private final Object _token;
    private final boolean _trace;
    private final boolean _releaseImmediately;

    TestArcExecutable(SimulatablePlaceInstance placeInstance, Object token, boolean releaseImmediately, boolean trace) {
        this._placeInstance = placeInstance;
        this._token = token;
        this._trace = trace;
        this._releaseImmediately = releaseImmediately;
    }

    public long lockPriority() {
        return this._placeInstance.getLockOrder();
    }

    @Override
    public int phase() {
        return -2;
    }

    public void lock() {
        this._placeInstance._lock.lock();
    }

    @Override
    public void verify(StepIdentifier stepIdentifier) throws Impossible {
        this._placeInstance.testToken(this._token);
    }

    @Override
    public void execute(StepIdentifier stepIdentifier) {
        PlaceEvent event;
        PlaceEvent placeEvent = event = this._releaseImmediately ? new QuicklyTesting(this._token, this._placeInstance) : new Testing(this._token, this._placeInstance);
        if (this._trace) {
            SimulatorEventLogger.log(stepIdentifier, (SimulationEvent)event, (PlaceInstance)this._placeInstance);
        }
        if (this._releaseImmediately) {
            this._placeInstance.untestToken(this._token);
        }
    }

    @Override
    public void rollback() {
        this._placeInstance.untestToken(this._token);
    }

    public void unlock() {
        this._placeInstance._lock.unlock();
    }

    SimulatablePlaceInstance getPlaceInstance() {
        return this._placeInstance;
    }

    Object getToken() {
        return this._token;
    }

    boolean isTrace() {
        return this._trace;
    }
}

